/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell.effects.modifiers;

import com.hakimen.wandrous.common.entity.static_spell.TimerEntity;
import com.hakimen.wandrous.common.registers.EntityRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.utils.data.Node;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class DelayCastEffect
extends SpellEffect {
    int time;

    public DelayCastEffect(int time) {
        this.time = time * 20;
        this.setKind(2);
        this.setStatus(new SpellStatus().setManaDrain(5 * time));
    }

    @Override
    public void cast(final SpellContext context) {
        context.mergeStatus(this.getStatus());
        TimerEntity timer = new TimerEntity(this, (EntityType)EntityRegister.TIMER_ENTITY.get(), context.getLevel(), this.time){

            @Override
            public void tick() {
                super.tick();
                if (this.tickedEnough()) {
                    context.getNode().getChildren().forEach(child -> {
                        this.setDeltaMovement(context.getCaster().getDeltaMovement());
                        ((SpellStack)child.getData()).getEffect().cast(context.setCaster(this).setNode((Node<SpellStack>)child));
                    });
                    this.discard();
                }
            }
        };
        timer.setPos(context.isCastPositionModified() ? context.getLocation() : context.getCaster().getPosition(0.0f));
        context.getLevel().addFreshEntity((Entity)timer);
    }
}

