/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell;

import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.registers.SpellRegister;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.utils.ChargesUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpellStack {
    boolean copy;
    SpellEffect effect;
    boolean hasCharges;
    int charges;
    ItemStack referenceStack;

    public SpellEffect getEffect() {
        return this.effect;
    }

    public SpellStack setEffect(SpellEffect effect) {
        this.effect = effect;
        return this;
    }

    public int getCharges() {
        return this.charges;
    }

    public SpellStack setCharges(int charges) {
        this.charges = charges;
        return this;
    }

    public SpellStack(SpellEffect effect, int charges) {
        this.effect = effect;
        this.charges = charges;
    }

    public SpellStack() {
    }

    public ItemStack getReferenceStack() {
        return this.referenceStack;
    }

    public SpellStack setReferenceStack(ItemStack referenceStack) {
        this.referenceStack = referenceStack;
        return this;
    }

    public boolean hasCharges() {
        return this.hasCharges;
    }

    public SpellStack setHasCharges(boolean hasCharges) {
        this.hasCharges = hasCharges;
        return this;
    }

    public boolean isCopy() {
        return this.copy;
    }

    public SpellStack setCopy(boolean copy) {
        this.copy = copy;
        return this;
    }

    public boolean isHasCharges() {
        return this.hasCharges;
    }

    public static SpellStack fromItemStack(ItemStack stack) {
        SpellStack spellStack = new SpellStack();
        if (stack == null || stack.isEmpty()) {
            spellStack.setEffect((SpellEffect)SpellRegister.DUMMY.get());
            spellStack.setCharges(0);
            return spellStack;
        }
        Item item = stack.getItem();
        if (item instanceof SpellEffectItem) {
            SpellEffectItem sei = (SpellEffectItem)item;
            spellStack.setEffect(sei.getSpellEffect());
        }
        if (ChargesUtils.hasCharge(stack)) {
            spellStack.setCharges(ChargesUtils.currentCharges(stack));
            spellStack.setHasCharges(true);
        }
        spellStack.setReferenceStack(stack);
        return spellStack;
    }

    public String toString() {
        return this.charges + " -> " + String.valueOf(this.effect) + " [" + String.valueOf(this.referenceStack) + "]";
    }
}

