/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.spell;

import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.utils.CastingUtils;
import com.hakimen.wandrous.common.utils.data.Node;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpellContext
implements Cloneable {
    HashMap<String, Object> properties = new HashMap();

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public SpellContext setProperties(HashMap<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public Entity getOriginalCaster() {
        return (Entity)this.properties.get("originalCaster");
    }

    public SpellContext setOriginalCaster(Entity originalCaster) {
        this.properties.put("originalCaster", originalCaster);
        return this;
    }

    public List<SpellEffect> getSpells() {
        return (List)this.properties.get("spells");
    }

    public SpellContext setSpells(List<SpellEffect> spells) {
        this.properties.put("spells", spells);
        return this;
    }

    public Entity getCaster() {
        return (Entity)this.properties.get("caster");
    }

    public SpellContext setCaster(Entity caster) {
        this.properties.put("caster", caster);
        return this;
    }

    public ItemStack getWand() {
        return (ItemStack)this.properties.get("wand");
    }

    public SpellContext setWand(ItemStack wand) {
        this.properties.put("wand", wand);
        return this;
    }

    public Level getLevel() {
        return (Level)this.properties.get("level");
    }

    public SpellContext setLevel(Level level) {
        this.properties.put("level", level);
        return this;
    }

    public Vec3 getLocation() {
        return (Vec3)this.properties.get("location");
    }

    public SpellContext setLocation(Vec3 location) {
        this.properties.put("location", location);
        return this;
    }

    public Node<SpellStack> getNode() {
        return (Node)this.properties.get("node");
    }

    public SpellContext setNode(Node<SpellStack> node) {
        this.properties.put("node", node);
        return this;
    }

    public SpellStatus getStatus() {
        return (SpellStatus)this.properties.get("status");
    }

    public SpellContext setStatus(SpellStatus status) {
        this.properties.put("status", status);
        return this;
    }

    public void mergeStatus(SpellStatus status) {
        this.setStatus(CastingUtils.mergeStatus(status, this.getStatus()));
    }

    public boolean isCastPositionModified() {
        return this.properties.containsKey("castPositionModified") && (Boolean)this.properties.get("castPositionModified") != false;
    }

    public SpellContext setCastPositionModified(boolean castPositionModified) {
        this.properties.put("castPositionModified", castPositionModified);
        return this;
    }

    public List<LivingEntity> getHit() {
        return (List)this.properties.get("hit");
    }

    public SpellContext setHit(List<LivingEntity> hit) {
        this.properties.put("hit", hit);
        return this;
    }

    public int getSplit() {
        return this.properties.containsKey("split") ? (Integer)this.properties.get("split") : 0;
    }

    public SpellContext setSplit(int split) {
        this.properties.put("split", split);
        return this;
    }

    public LivingEntity getHomingTarget() {
        return (LivingEntity)this.properties.get("homingTarget");
    }

    public SpellContext setHomingTarget(LivingEntity homingTarget) {
        this.properties.put("homingTarget", homingTarget);
        return this;
    }

    public boolean isPiercing() {
        return this.properties.containsKey("piercing") && (Boolean)this.properties.get("piercing") != false;
    }

    public SpellContext setPiercing(boolean piercing) {
        this.properties.put("piercing", piercing);
        return this;
    }

    public boolean isCanHitCaster() {
        return this.properties.containsKey("hits_caster") && (Boolean)this.properties.get("hits_caster") != false;
    }

    public SpellContext setCanHitCaster(boolean hitcaster) {
        this.properties.put("hits_caster", hitcaster);
        return this;
    }

    public SpellContext clone() {
        return new SpellContext().setProperties((HashMap)this.properties.clone());
    }
}

