/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.recipe;

import com.hakimen.wandrous.common.custom.register.WandrousRegistries;
import com.hakimen.wandrous.common.item.component.InscribedLensDataComponent;
import com.hakimen.wandrous.common.recipe.ArcaneInscriberRecipeInput;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ArcaneInscribingRecipe
implements Recipe<ArcaneInscriberRecipeInput> {
    final ResourceLocation id;
    final NonNullList<ResourceLocation> requiredGlyphs;
    final Ingredient onSlate;
    final ItemStack output;
    final int tier;
    final int ticksNeeded;

    public ArcaneInscribingRecipe(ResourceLocation id, NonNullList<ResourceLocation> requiredGlyphs, Ingredient onSlate, ItemStack output, int tier, int ticksNeeded) {
        this.id = id;
        this.requiredGlyphs = requiredGlyphs;
        this.onSlate = onSlate;
        this.output = output;
        this.tier = tier;
        this.ticksNeeded = ticksNeeded;
    }

    public NonNullList<ResourceLocation> getRequiredGlyphs() {
        return this.requiredGlyphs;
    }

    public Ingredient getOnSlate() {
        return this.onSlate;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getTier() {
        return this.tier;
    }

    public int getTicksNeeded() {
        return this.ticksNeeded;
    }

    public boolean matches(ArcaneInscriberRecipeInput input, Level level) {
        if (input.tier < this.tier) {
            return false;
        }
        if (!this.onSlate.test(input.getOnSlate())) {
            return false;
        }
        HashMap<ResourceLocation, Integer> recipeGlyphs = new HashMap<ResourceLocation, Integer>();
        for (ResourceLocation requiredGlyph : this.requiredGlyphs) {
            Optional maybeGlyph = WandrousRegistries.GLYPH_REGISTER.getOptional(requiredGlyph);
            if (maybeGlyph.isEmpty()) {
                return false;
            }
            if (recipeGlyphs.containsKey(requiredGlyph)) {
                recipeGlyphs.put(requiredGlyph, (Integer)recipeGlyphs.get(requiredGlyph) + 1);
                continue;
            }
            recipeGlyphs.put(requiredGlyph, 1);
        }
        for (ItemStack item : input.getContainer().getItems()) {
            if (!item.has((DataComponentType)DataComponentsRegister.GLYPH_COMPONENT.get())) continue;
            InscribedLensDataComponent.GlyphData glyphData = (InscribedLensDataComponent.GlyphData)item.get((DataComponentType)DataComponentsRegister.GLYPH_COMPONENT.get());
            if (recipeGlyphs.containsKey(glyphData.getId())) {
                if ((Integer)recipeGlyphs.get(glyphData.getId()) <= 0) continue;
                recipeGlyphs.put(glyphData.getId(), (Integer)recipeGlyphs.get(glyphData.getId()) - 1);
                if ((Integer)recipeGlyphs.get(glyphData.getId()) != 0) continue;
                recipeGlyphs.remove(glyphData.getId());
                continue;
            }
            return false;
        }
        return recipeGlyphs.isEmpty();
    }

    public ItemStack assemble(ArcaneInscriberRecipeInput input, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ArcaneInscribingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"arcane_inscribing");

        public MapCodec<ArcaneInscribingRecipe> codec() {
            return RecordCodecBuilder.mapCodec(arcaneInscribingRecipeInstance -> arcaneInscribingRecipeInstance.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(recipe -> ID), (App)NonNullList.codecOf((Codec)ResourceLocation.CODEC).fieldOf("glyphs").validate(resourceLocations -> resourceLocations.size() > 16 ? DataResult.error(() -> "Invalid amount of glyphs, expected to be in range 1..16, got" + resourceLocations.size()) : DataResult.success((Object)resourceLocations)).forGetter(ArcaneInscribingRecipe::getRequiredGlyphs), (App)Ingredient.CODEC.fieldOf("on_slate").forGetter(ArcaneInscribingRecipe::getOnSlate), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("output").forGetter(ArcaneInscribingRecipe::getOutput), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("tier").validate(integer -> integer <= 0 || integer > 4 ? DataResult.error(() -> "Tier value invalid, expected to be in range 1..4, got " + integer) : DataResult.success((Object)integer)).forGetter(ArcaneInscribingRecipe::getTier), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("ticks").forGetter(ArcaneInscribingRecipe::getTicksNeeded)).apply((Applicative)arcaneInscribingRecipeInstance, ArcaneInscribingRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, ArcaneInscribingRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, ArcaneInscribingRecipe>(this){

                public ArcaneInscribingRecipe decode(RegistryFriendlyByteBuf pBuffer) {
                    ResourceLocation id = pBuffer.readResourceLocation();
                    NonNullList requiredGlyphs = NonNullList.create();
                    pBuffer.readCollection(value -> requiredGlyphs, (StreamDecoder)ResourceLocation.STREAM_CODEC);
                    int ticks = pBuffer.readInt();
                    int tier = pBuffer.readInt();
                    Ingredient onSlate = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
                    ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
                    return new ArcaneInscribingRecipe(id, (NonNullList<ResourceLocation>)requiredGlyphs, onSlate, output, tier, ticks);
                }

                public void encode(RegistryFriendlyByteBuf pBuffer, ArcaneInscribingRecipe pValue) {
                    pBuffer.writeResourceLocation(pValue.id);
                    pBuffer.writeCollection(pValue.getRequiredGlyphs(), (StreamEncoder)ResourceLocation.STREAM_CODEC);
                    pBuffer.writeInt(pValue.getTicksNeeded());
                    pBuffer.writeInt(pValue.getTier());
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pValue.getOnSlate());
                    ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pValue.getOutput());
                }
            };
        }
    }

    public static class Type
    implements RecipeType<ArcaneInscribingRecipe> {
        public static final String ID = "arcane_inscribing";
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

