/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.particle;

import com.hakimen.wandrous.client.utils.EasingUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class ShockwaveParticle
extends TextureSheetParticle {
    SpriteSet sprites;

    public ShockwaveParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet sprites, double vX, double vY, double vZ) {
        super(pLevel, pX, pY, pZ);
        this.xd = vX;
        this.yd = vY;
        this.zd = vZ;
        this.gravity = 0.0f;
        this.lifetime = 320;
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.setAlpha((float)(1.0 - EasingUtils.easeInOutQuart((float)this.age / (float)this.lifetime)));
    }

    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Quaternionf quaternionf = new Quaternionf();
        this.getFacingCameraMode().setRotation(quaternionf, pRenderInfo, pPartialTicks);
        if (this.roll != 0.0f) {
            quaternionf.rotateZ(Mth.lerp((float)pPartialTicks, (float)this.oRoll, (float)this.roll));
        }
        this.quadSize += ((float)this.age + pPartialTicks) / (float)this.lifetime * 0.24f;
        quaternionf.rotationXYZ(-1.5707964f, 0.0f, 0.0f);
        this.renderRotatedQuad(pBuffer, pRenderInfo, quaternionf, pPartialTicks);
    }

    public ParticleRenderType getRenderType() {
        return new ParticleRenderType(this){

            @Nullable
            public BufferBuilder begin(Tesselator p_350949_, TextureManager p_107437_) {
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
                RenderSystem.enableBlend();
                RenderSystem.disableCull();
                RenderSystem.defaultBlendFunc();
                return p_350949_.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ShockwaveProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public ShockwaveProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vX, double vY, double vZ) {
            ShockwaveParticle particle = new ShockwaveParticle(clientLevel, x, y, z, this.sprites, 0.0, 0.0, 0.0);
            return particle;
        }
    }
}

