/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.particle;

import com.hakimen.wandrous.common.particle.ParticleRenderTypes;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class GlimmeringBoltParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public GlimmeringBoltParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet sprites, double vX, double vY, double vZ) {
        super(pLevel, pX, pY, pZ);
        this.xd = vX;
        this.yd = vY;
        this.zd = vZ;
        this.quadSize *= 0.85f;
        this.gravity = 0.0f;
        this.lifetime = 50;
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.setAlpha(1.0f - (float)this.age / (float)this.lifetime);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.ADDITIVE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ChainShotProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public ChainShotProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vX, double vY, double vZ) {
            Random r = new Random();
            GlimmeringBoltParticle particle = new GlimmeringBoltParticle(clientLevel, x + (double)r.nextFloat(-0.1f, 0.1f), y + (double)r.nextFloat(-0.1f, 0.1f), z + (double)r.nextFloat(-0.1f, 0.1f), this.sprites, vX + (double)r.nextFloat(-0.1f, 0.1f), vY + (double)r.nextFloat(-0.1f, 0.1f), vZ + (double)r.nextFloat(-0.1f, 0.1f));
            float g = r.nextFloat(0.2f, 1.0f);
            float b = r.nextFloat(0.137f, 0.686f);
            particle.setColor(0.0f, g, b);
            particle.xd *= 0.1f;
            particle.yd *= 0.1f;
            particle.zd *= 0.1f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GlimmeringHitProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public GlimmeringHitProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vX, double vY, double vZ) {
            Random r = new Random();
            GlimmeringBoltParticle particle = new GlimmeringBoltParticle(clientLevel, x, y, z, this.sprites, vX + (double)r.nextFloat(), vY + (double)r.nextFloat(), vZ + (double)r.nextFloat());
            float brightness = r.nextFloat(0.15f, 0.25f);
            particle.setColor(0.475f, 0.0f + brightness, 0.678f);
            particle.xd *= 0.05f;
            particle.yd *= 0.05f;
            particle.zd *= 0.05f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GlimmeringProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public GlimmeringProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vX, double vY, double vZ) {
            Random r = new Random();
            GlimmeringBoltParticle particle = new GlimmeringBoltParticle(clientLevel, x, y, z, this.sprites, vX + (double)r.nextFloat(), vY + (double)r.nextFloat(), vZ + (double)r.nextFloat());
            float brightness = r.nextFloat(0.25f, 0.5f);
            particle.setColor(1.0f, brightness, 0.992f);
            particle.xd *= 0.1f;
            particle.yd *= 0.1f;
            particle.zd *= 0.1f;
            return particle;
        }
    }
}

