/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.particle;

import com.hakimen.wandrous.common.particle.ParticleRenderTypes;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FieryParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public FieryParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet sprites, double vX, double vY, double vZ) {
        super(pLevel, pX, pY, pZ);
        this.xd = vX;
        this.yd = vY;
        this.zd = vZ;
        this.quadSize *= 4.0f;
        this.gravity = 0.0f;
        this.lifetime = 40;
        this.sprites = sprites;
        this.setSprite(sprites.get(this.random));
    }

    public void tick() {
        super.tick();
        this.setAlpha(1.0f - (float)this.age / (float)this.lifetime);
        this.quadSize = Math.max(0.0f, this.quadSize * 0.9f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.ADDITIVE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FreezingGazeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FreezingGazeProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vX, double vY, double vZ) {
            Random r = new Random();
            FieryParticle particle = new FieryParticle(clientLevel, x, y, z, this.sprites, vX * 0.1, vY * 0.1, vZ * 0.1);
            if ((double)r.nextFloat() > 0.95) {
                particle.setColor(1.0f, 1.0f, 1.0f);
            } else if ((double)r.nextFloat() > 0.75) {
                particle.setColor(0.0f, 1.0f, 1.0f);
            } else if ((double)r.nextFloat() > 0.45) {
                particle.setColor(0.0f, 0.8f, 1.0f);
            } else {
                particle.setColor(0.0f, 0.6f, 1.0f);
            }
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FieryProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FieryProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vX, double vY, double vZ) {
            Random r = new Random();
            FieryParticle particle = new FieryParticle(clientLevel, x, y, z, this.sprites, vX * 0.1, vY * 0.1, vZ * 0.1);
            if ((double)r.nextFloat() > 0.95) {
                particle.setColor(1.0f, 1.0f, 0.7f);
            } else if ((double)r.nextFloat() > 0.75) {
                particle.setColor(1.0f, 0.3f, 0.0f);
            } else if ((double)r.nextFloat() > 0.45) {
                particle.setColor(1.0f, 0.2f, 0.0f);
            } else {
                particle.setColor(1.0f, 0.1f, 0.0f);
            }
            return particle;
        }
    }
}

