/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.particle;

import com.hakimen.wandrous.common.registers.ParticleRegister;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ArcaneKnowledgeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public ArcaneKnowledgeParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet sprites, double vX, double vY, double vZ) {
        super(pLevel, pX, pY, pZ);
        this.xd = vX;
        this.yd = vY;
        this.zd = vZ;
        this.quadSize *= 0.85f;
        this.gravity = 0.0f;
        this.lifetime = 50;
        this.sprites = sprites;
        this.sprite = sprites.get(pLevel.random);
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    public void tick() {
        super.tick();
        this.alpha = 1.0f - (float)this.age / (float)this.lifetime;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ArcaneKnowledgeParticleProvider
    implements ParticleProvider<ArcaneKnowledgeParticleOptions> {
        private final SpriteSet sprites;

        public ArcaneKnowledgeParticleProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(ArcaneKnowledgeParticleOptions simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vX, double vY, double vZ) {
            ArcaneKnowledgeParticle particle = new ArcaneKnowledgeParticle(clientLevel, x, y, z, this.sprites, vX, vY + 0.4, vZ);
            particle.setColor(simpleParticleType.rgb[0], simpleParticleType.rgb[1], simpleParticleType.rgb[2]);
            particle.xd *= 0.1f;
            particle.yd *= 0.1f;
            particle.zd *= 0.1f;
            return particle;
        }
    }

    public static class ArcaneKnowledgeParticleOptions
    implements ParticleOptions {
        float[] rgb;

        public ArcaneKnowledgeParticleOptions(float r, float g, float b) {
            this.rgb = new float[]{r, g, b};
        }

        public ParticleType<?> getType() {
            return (ParticleType)ParticleRegister.KNOWLEDGE.get();
        }
    }

    public static class ArcaneKnowledgeParticleType
    extends ParticleType<ArcaneKnowledgeParticleOptions> {
        public ArcaneKnowledgeParticleType() {
            super(true);
        }

        public MapCodec<ArcaneKnowledgeParticleOptions> codec() {
            return RecordCodecBuilder.mapCodec(arcaneKnowledgeParticleOptionsInstance -> arcaneKnowledgeParticleOptionsInstance.group((App)Codec.FLOAT.fieldOf("r").validate(val -> val.floatValue() >= 0.0f && val.floatValue() <= 1.0f ? DataResult.success((Object)val) : DataResult.error(() -> "Invalid float range (0..1) for color channel r")).forGetter(particle -> Float.valueOf(particle.rgb[0])), (App)Codec.FLOAT.fieldOf("g").validate(val -> val.floatValue() >= 0.0f && val.floatValue() <= 1.0f ? DataResult.success((Object)val) : DataResult.error(() -> "Invalid float range (0..1) for color channel g")).forGetter(particle -> Float.valueOf(particle.rgb[1])), (App)Codec.FLOAT.fieldOf("b").validate(val -> val.floatValue() >= 0.0f && val.floatValue() <= 1.0f ? DataResult.success((Object)val) : DataResult.error(() -> "Invalid float range (0..1) for color channel b")).forGetter(particle -> Float.valueOf(particle.rgb[2]))).apply((Applicative)arcaneKnowledgeParticleOptionsInstance, ArcaneKnowledgeParticleOptions::new));
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ArcaneKnowledgeParticleOptions> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, ArcaneKnowledgeParticleOptions>(this){

                public ArcaneKnowledgeParticleOptions decode(RegistryFriendlyByteBuf pBuffer) {
                    float r = pBuffer.readFloat();
                    float g = pBuffer.readFloat();
                    float b = pBuffer.readFloat();
                    return new ArcaneKnowledgeParticleOptions(r, g, b);
                }

                public void encode(RegistryFriendlyByteBuf pBuffer, ArcaneKnowledgeParticleOptions pValue) {
                    pBuffer.writeFloat(pValue.rgb[0]);
                    pBuffer.writeFloat(pValue.rgb[1]);
                    pBuffer.writeFloat(pValue.rgb[2]);
                }
            };
        }
    }
}

