/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.loot;

import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.registers.ItemRegister;
import com.hakimen.wandrous.common.spell.effects.spells.BestowSpellEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AppendBestowSpellsModifier
extends LootModifier {
    public static final MapCodec<AppendBestowSpellsModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ExtraCodecs.POSITIVE_INT.fieldOf("quantity").forGetter(quant -> quant.maxQuantity)).apply((Applicative)inst, AppendBestowSpellsModifier::new));
    public int maxQuantity;

    public AppendBestowSpellsModifier(LootItemCondition[] conditionsIn, int maxQuantity) {
        super(conditionsIn);
        this.maxQuantity = maxQuantity;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        int qtn = 0;
        List<Item> bestowSpells = ItemRegister.ITEMS.getEntries().stream().filter(itemDeferredHolder -> {
            SpellEffectItem effect;
            Object patt0$temp = itemDeferredHolder.get();
            return patt0$temp instanceof SpellEffectItem && (effect = (SpellEffectItem)((Object)((Object)patt0$temp))).getSpellEffect() instanceof BestowSpellEffect;
        }).map(DeferredHolder::get).toList();
        for (Item bestowSpell : bestowSpells) {
            if (context.getRandom().nextFloat() < 0.25f) {
                generatedLoot.add((Object)bestowSpell.getDefaultInstance());
                ++qtn;
            }
            if (qtn < this.maxQuantity) continue;
            break;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

