/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class AddItemsModifier
extends LootModifier {
    public static final MapCodec<AddItemsModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AddItemsModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ExtraCodecs.POSITIVE_FLOAT).fieldOf("items").forGetter(addItemModifier -> addItemModifier.addItems)).apply((Applicative)inst, AddItemsModifier::new));
    Map<String, Float> addItems;

    public AddItemsModifier(LootItemCondition[] conditionsIn, Map<String, Float> addItems) {
        super(conditionsIn);
        this.addItems = addItems;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        this.addItems.forEach((resourceKey, weight) -> {
            if (context.getRandom().nextFloat() < weight.floatValue()) {
                ResourceLocation location = ResourceLocation.tryParse((String)resourceKey);
                generatedLoot.add((Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(location)));
            }
        });
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

