/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

public class WandDataComponent {
    public static WandStat DEFAULT_STAT = new WandStat(0, 0, 0, Float.valueOf(0.0f), Float.valueOf(0.0f), 0, 0, 0, 0, 0, new CompoundTag(), "", 0, 0, false);
    public static Codec<WandStat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("Capacity").forGetter(wandStat -> wandStat.capacity), (App)Codec.INT.fieldOf("MaxMana").forGetter(wandStat -> wandStat.maxMana), (App)Codec.INT.fieldOf("Mana").forGetter(wandStat -> wandStat.mana), (App)Codec.FLOAT.fieldOf("CastDelay").forGetter(wandStat -> Float.valueOf(wandStat.castDelay)), (App)Codec.FLOAT.fieldOf("RechargeSpeed").forGetter(wandStat -> Float.valueOf(wandStat.rechargeSpeed)), (App)Codec.INT.fieldOf("ManaChargeSpeed").forGetter(wandStat -> wandStat.manaChargeSpeed), (App)Codec.INT.fieldOf("CastableSize").forGetter(wandStat -> wandStat.castableSize), (App)Codec.INT.fieldOf("CurrentIdx").forGetter(wandStat -> wandStat.currentIdx), (App)Codec.INT.fieldOf("Gem").forGetter(wandStat -> wandStat.gem), (App)Codec.INT.fieldOf("Wand").forGetter(wandStat -> wandStat.wand), (App)CompoundTag.CODEC.fieldOf("Inventory").forGetter(wandStat -> wandStat.inventory), (App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("WandName").forGetter(wandStat -> wandStat.name), (App)Codec.INT.fieldOf("Cooldown").forGetter(wandStat -> wandStat.wandCooldown), (App)Codec.INT.fieldOf("MaxCooldown").forGetter(wandStat -> wandStat.maxCooldown), (App)Codec.BOOL.fieldOf("FromCastDelay").forGetter(wandStat -> wandStat.fromCastDelay)).apply((Applicative)instance, WandStat::new));
    public static StreamCodec<RegistryFriendlyByteBuf, WandStat> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, WandStat>(){

        public WandStat decode(RegistryFriendlyByteBuf pBuffer) {
            int capacity = pBuffer.readInt();
            int maxMana = pBuffer.readInt();
            int mana = pBuffer.readInt();
            float castDelay = pBuffer.readFloat();
            float rechargeSpeed = pBuffer.readFloat();
            int manaChargeSpeed = pBuffer.readInt();
            int castableSize = pBuffer.readInt();
            int currentIdx = pBuffer.readInt();
            int gem = pBuffer.readInt();
            int wand = pBuffer.readInt();
            CompoundTag inventory = pBuffer.readNbt();
            String name = pBuffer.readUtf();
            int wandCooldown = pBuffer.readInt();
            int maxCooldown = pBuffer.readInt();
            boolean fromCastDelay = pBuffer.readBoolean();
            WandStat stat = new WandStat(capacity, maxMana, mana, Float.valueOf(castDelay), Float.valueOf(rechargeSpeed), manaChargeSpeed, castableSize, currentIdx, gem, wand, inventory, name, wandCooldown, maxCooldown, fromCastDelay);
            return stat;
        }

        public void encode(RegistryFriendlyByteBuf pBuffer, WandStat pValue) {
            pBuffer.writeInt(pValue.getCapacity());
            pBuffer.writeInt(pValue.getMaxMana());
            pBuffer.writeInt(pValue.getMana());
            pBuffer.writeFloat(pValue.getCastDelay());
            pBuffer.writeFloat(pValue.getRechargeSpeed());
            pBuffer.writeInt(pValue.getManaChargeSpeed());
            pBuffer.writeInt(pValue.getCastableSize());
            pBuffer.writeInt(pValue.getCurrentIdx());
            pBuffer.writeInt(pValue.getGem());
            pBuffer.writeInt(pValue.getWand());
            pBuffer.writeNbt((Tag)pValue.getInventory());
            pBuffer.writeUtf(pValue.getName());
            pBuffer.writeInt(pValue.getWandCooldown());
            pBuffer.writeInt(pValue.getMaxCooldown());
            pBuffer.writeBoolean(pValue.isFromCastDelay());
        }
    };

    public static class WandStat {
        final int capacity;
        final int maxMana;
        final int mana;
        final float castDelay;
        final float rechargeSpeed;
        final int manaChargeSpeed;
        final int castableSize;
        final int currentIdx;
        final int gem;
        final int wand;
        final int wandCooldown;
        final CompoundTag inventory;
        final String name;
        final boolean fromCastDelay;
        final int maxCooldown;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WandStat stat = (WandStat)o;
            return this.capacity == stat.capacity && this.maxMana == stat.maxMana && this.mana == stat.mana && Float.compare(this.castDelay, stat.castDelay) == 0 && Float.compare(this.rechargeSpeed, stat.rechargeSpeed) == 0 && this.manaChargeSpeed == stat.manaChargeSpeed && this.castableSize == stat.castableSize && this.currentIdx == stat.currentIdx && this.gem == stat.gem && this.wand == stat.wand && this.wandCooldown == stat.wandCooldown && this.fromCastDelay == stat.fromCastDelay && Objects.equals(this.inventory, stat.inventory) && Objects.equals(this.name, stat.name);
        }

        public int hashCode() {
            return Objects.hash(this.capacity, this.maxMana, this.mana, Float.valueOf(this.castDelay), Float.valueOf(this.rechargeSpeed), this.manaChargeSpeed, this.castableSize, this.currentIdx, this.gem, this.wand, this.wandCooldown, this.inventory, this.name, this.fromCastDelay);
        }

        public WandStat(Integer capacity, Integer maxMana, Integer mana, Float castDelay, Float rechargeSpeed, Integer manaChargeSpeed, Integer castableSize, Integer currentIdx, Integer gem, Integer wand, CompoundTag inventory, String name, int wandCooldown, int maxCooldown, boolean fromCastDelay) {
            this.capacity = capacity;
            this.maxMana = maxMana;
            this.mana = mana;
            this.castDelay = castDelay.floatValue();
            this.rechargeSpeed = rechargeSpeed.floatValue();
            this.manaChargeSpeed = manaChargeSpeed;
            this.castableSize = castableSize;
            this.currentIdx = currentIdx;
            this.gem = gem;
            this.wand = wand;
            this.inventory = inventory;
            this.name = name;
            this.wandCooldown = wandCooldown;
            this.maxCooldown = maxCooldown;
            this.fromCastDelay = fromCastDelay;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getMaxMana() {
            return this.maxMana;
        }

        public int getMana() {
            return this.mana;
        }

        public float getCastDelay() {
            return this.castDelay;
        }

        public float getRechargeSpeed() {
            return this.rechargeSpeed;
        }

        public int getManaChargeSpeed() {
            return this.manaChargeSpeed;
        }

        public int getCastableSize() {
            return this.castableSize;
        }

        public int getCurrentIdx() {
            return this.currentIdx;
        }

        public int getGem() {
            return this.gem;
        }

        public int getWand() {
            return this.wand;
        }

        public CompoundTag getInventory() {
            return this.inventory;
        }

        public String getName() {
            return this.name;
        }

        public int getWandCooldown() {
            return this.wandCooldown;
        }

        public int getMaxCooldown() {
            return this.maxCooldown;
        }

        public boolean isFromCastDelay() {
            return this.fromCastDelay;
        }
    }

    public static class WandStatBuilder {
        int capacity;
        int maxMana;
        int mana;
        float castDelay;
        int wandCooldown;
        int maxCooldown;
        float rechargeSpeed;
        int manaChargeSpeed;
        int castableSize;
        int currentIdx;
        int gem;
        int wand;
        boolean fromCastDelay;
        CompoundTag inventory;
        String wandName;

        public WandStatBuilder() {
        }

        public WandStatBuilder(WandStat stat) {
            this.capacity = stat.capacity;
            this.maxMana = stat.maxMana;
            this.mana = stat.mana;
            this.castDelay = stat.castDelay;
            this.rechargeSpeed = stat.rechargeSpeed;
            this.manaChargeSpeed = stat.manaChargeSpeed;
            this.castableSize = stat.castableSize;
            this.currentIdx = stat.currentIdx;
            this.gem = stat.gem;
            this.wand = stat.wand;
            this.wandCooldown = stat.wandCooldown;
            this.inventory = stat.inventory;
            this.wandName = stat.name;
            this.fromCastDelay = stat.fromCastDelay;
            this.maxCooldown = stat.maxCooldown;
        }

        public WandStatBuilder setCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public WandStatBuilder setMaxMana(int maxMana) {
            this.maxMana = maxMana;
            return this;
        }

        public WandStatBuilder setMana(int mana) {
            this.mana = mana;
            return this;
        }

        public WandStatBuilder setCastDelay(float castDelay) {
            this.castDelay = castDelay;
            return this;
        }

        public WandStatBuilder setRechargeSpeed(float rechargeSpeed) {
            this.rechargeSpeed = rechargeSpeed;
            return this;
        }

        public WandStatBuilder setManaChargeSpeed(int manaChargeSpeed) {
            this.manaChargeSpeed = manaChargeSpeed;
            return this;
        }

        public WandStatBuilder setCastableSize(int castableSize) {
            this.castableSize = castableSize;
            return this;
        }

        public WandStatBuilder setCurrentIdx(int currentIdx) {
            this.currentIdx = currentIdx;
            return this;
        }

        public WandStatBuilder setGem(int gem) {
            this.gem = gem;
            return this;
        }

        public WandStatBuilder setWand(int wand) {
            this.wand = wand;
            return this;
        }

        public WandStatBuilder setInventory(CompoundTag inventory) {
            this.inventory = inventory;
            return this;
        }

        public WandStatBuilder setWandName(String wandName) {
            this.wandName = wandName;
            return this;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getMaxMana() {
            return this.maxMana;
        }

        public int getMana() {
            return this.mana;
        }

        public float getCastDelay() {
            return this.castDelay;
        }

        public float getRechargeSpeed() {
            return this.rechargeSpeed;
        }

        public int getManaChargeSpeed() {
            return this.manaChargeSpeed;
        }

        public int getCastableSize() {
            return this.castableSize;
        }

        public int getCurrentIdx() {
            return this.currentIdx;
        }

        public int getGem() {
            return this.gem;
        }

        public int getWand() {
            return this.wand;
        }

        public CompoundTag getInventory() {
            return this.inventory;
        }

        public String getWandName() {
            return this.wandName;
        }

        public int getWandCooldown() {
            return this.wandCooldown;
        }

        public WandStatBuilder setWandCooldown(int wandCooldown) {
            this.wandCooldown = wandCooldown;
            return this;
        }

        public boolean isFromCastDelay() {
            return this.fromCastDelay;
        }

        public WandStatBuilder setFromCastDelay(boolean fromCastDelay) {
            this.fromCastDelay = fromCastDelay;
            return this;
        }

        public int getMaxCooldown() {
            return this.maxCooldown;
        }

        public WandStatBuilder setMaxCooldown(int maxCooldown) {
            this.maxCooldown = maxCooldown;
            return this;
        }

        public WandStat build() {
            return new WandStat(this.capacity, this.maxMana, this.mana, Float.valueOf(this.castDelay), Float.valueOf(this.rechargeSpeed), this.manaChargeSpeed, this.castableSize, this.currentIdx, this.gem, this.wand, this.inventory, this.wandName, this.wandCooldown, this.maxCooldown, this.fromCastDelay);
        }
    }
}

