/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class SpellCastsDataComponent {
    public static final SpellCastsData DEFAULT = new SpellCastsData(-1, -1);
    public static final Codec<SpellCastsData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("max_casts").forGetter(SpellCastsData::getMaxCasts), (App)Codec.INT.fieldOf("remaining").forGetter(SpellCastsData::getRemaining)).apply((Applicative)instance, SpellCastsData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellCastsData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SpellCastsData>(){

        public SpellCastsData decode(RegistryFriendlyByteBuf pBuffer) {
            SpellCastsDataBuilder builder = new SpellCastsDataBuilder();
            builder.setMaxCasts(pBuffer.readInt());
            builder.setRemaining(pBuffer.readInt());
            return builder.build();
        }

        public void encode(RegistryFriendlyByteBuf pBuffer, SpellCastsData pValue) {
            pBuffer.writeInt(pValue.getMaxCasts());
            pBuffer.writeInt(pValue.getRemaining());
        }
    };

    public static class SpellCastsData {
        private final int maxCasts;
        private final int remaining;

        public SpellCastsData(int maxCasts, int remaining) {
            this.maxCasts = maxCasts;
            this.remaining = remaining;
        }

        public int getMaxCasts() {
            return this.maxCasts;
        }

        public int getRemaining() {
            return this.remaining;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpellCastsData that = (SpellCastsData)o;
            return this.maxCasts == that.maxCasts && this.remaining == that.remaining;
        }

        public int hashCode() {
            return Objects.hash(this.maxCasts, this.remaining);
        }
    }

    public static class SpellCastsDataBuilder {
        private int maxCasts;
        private int remaining;

        public int getMaxCasts() {
            return this.maxCasts;
        }

        public SpellCastsDataBuilder setMaxCasts(int maxCasts) {
            this.maxCasts = maxCasts;
            return this;
        }

        public int getRemaining() {
            return this.remaining;
        }

        public SpellCastsDataBuilder setRemaining(int remaining) {
            this.remaining = remaining;
            return this;
        }

        public SpellCastsData build() {
            return new SpellCastsData(this.maxCasts, this.remaining);
        }

        public SpellCastsDataBuilder(SpellCastsData spellCastsData) {
            this.maxCasts = spellCastsData.maxCasts;
            this.remaining = spellCastsData.remaining;
        }

        public SpellCastsDataBuilder() {
        }
    }
}

