/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ScrollDataComponent {
    public static final ScrollData DEFAULT = new ScrollData(List.of(), "");
    public static final Codec<ScrollData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).fieldOf("spells").forGetter(scrollData -> scrollData.spells), (App)Codec.STRING.fieldOf("name").forGetter(scrollData -> scrollData.name)).apply((Applicative)instance, ScrollData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScrollData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ScrollData>(){

        public ScrollData decode(RegistryFriendlyByteBuf pBuffer) {
            ScrollDataBuilder builder = new ScrollDataBuilder();
            builder.setName(pBuffer.readUtf());
            builder.setSpells(pBuffer.readList(FriendlyByteBuf::readUtf));
            return builder.build();
        }

        public void encode(RegistryFriendlyByteBuf pBuffer, ScrollData pValue) {
            pBuffer.writeUtf(pValue.name);
            pBuffer.writeCollection(pValue.spells, FriendlyByteBuf::writeUtf);
        }
    };

    public static class ScrollData {
        final List<String> spells;
        final String name;

        public ScrollData(List<String> spells, String name) {
            this.spells = spells;
            this.name = name;
        }

        public List<String> getSpells() {
            return this.spells;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScrollData that = (ScrollData)o;
            return Objects.equals(this.spells, that.spells) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.spells, this.name);
        }
    }

    public static class ScrollDataBuilder {
        List<String> spells;
        String name;

        public ScrollDataBuilder() {
        }

        public ScrollDataBuilder(ScrollData data) {
            this.name = data.name;
            this.spells = data.spells;
        }

        public List<String> getSpells() {
            return this.spells;
        }

        public ScrollDataBuilder setSpells(List<String> spells) {
            this.spells = spells;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public ScrollDataBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public ScrollData build() {
            return new ScrollData(this.spells, this.name);
        }
    }
}

