/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class InscribedLensDataComponent {
    public static GlyphData DEFAULT = new GlyphData(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"), 0.0f, 0.0f, 0.0f, 0.0f);
    public static Codec<GlyphData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(GlyphData::getId), (App)ResourceLocation.CODEC.fieldOf("glyph").forGetter(GlyphData::getTextureName), (App)Codec.FLOAT.fieldOf("r").validate(val -> val.floatValue() >= 0.0f && val.floatValue() <= 1.0f ? DataResult.success((Object)val) : DataResult.error(() -> "Invalid float range (0..1) for color channel r")).forGetter(glyphData -> Float.valueOf(glyphData.color[0])), (App)Codec.FLOAT.fieldOf("g").validate(val -> val.floatValue() >= 0.0f && val.floatValue() <= 1.0f ? DataResult.success((Object)val) : DataResult.error(() -> "Invalid float range (0..1) for color channel g")).forGetter(glyphData -> Float.valueOf(glyphData.color[1])), (App)Codec.FLOAT.fieldOf("b").validate(val -> val.floatValue() >= 0.0f && val.floatValue() <= 1.0f ? DataResult.success((Object)val) : DataResult.error(() -> "Invalid float range (0..1) for color channel b")).forGetter(glyphData -> Float.valueOf(glyphData.color[2])), (App)Codec.FLOAT.fieldOf("a").validate(val -> val.floatValue() >= 0.0f && val.floatValue() <= 1.0f ? DataResult.success((Object)val) : DataResult.error(() -> "Invalid float range (0..1) for color channel a")).forGetter(glyphData -> Float.valueOf(glyphData.color[3]))).apply((Applicative)instance, GlyphData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, GlyphData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, GlyphData>(){

        public GlyphData decode(RegistryFriendlyByteBuf pBuffer) {
            GlyphDataBuilder builder = new GlyphDataBuilder();
            builder.setId(pBuffer.readResourceLocation());
            builder.setTextureName(pBuffer.readResourceLocation());
            float r = pBuffer.readFloat();
            float g = pBuffer.readFloat();
            float b = pBuffer.readFloat();
            float a = pBuffer.readFloat();
            builder.setColor(new float[]{r, g, b, a});
            return builder.build();
        }

        public void encode(RegistryFriendlyByteBuf pBuffer, GlyphData pValue) {
            pBuffer.writeResourceLocation(pValue.getId());
            pBuffer.writeResourceLocation(pValue.getTextureName());
            pBuffer.writeFloat(pValue.getColor()[0]);
            pBuffer.writeFloat(pValue.getColor()[1]);
            pBuffer.writeFloat(pValue.getColor()[2]);
            pBuffer.writeFloat(pValue.getColor()[3]);
        }
    };

    public static class GlyphData {
        private final ResourceLocation id;
        private final ResourceLocation textureName;
        private final float[] color = new float[4];

        public GlyphData(ResourceLocation id, ResourceLocation textureName, float r, float g, float b, float a) {
            this.id = id;
            this.textureName = textureName;
            this.color[0] = r;
            this.color[1] = g;
            this.color[2] = b;
            this.color[3] = a;
        }

        public ResourceLocation getTextureName() {
            return this.textureName;
        }

        public float[] getColor() {
            return this.color;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GlyphData glyphData = (GlyphData)o;
            return Objects.equals(this.textureName, glyphData.textureName) && Objects.deepEquals(this.color, glyphData.color);
        }

        public int hashCode() {
            return Objects.hash(this.textureName, Arrays.hashCode(this.color));
        }
    }

    public static class GlyphDataBuilder {
        private ResourceLocation id;
        private ResourceLocation textureName;
        private float[] color = new float[4];

        public GlyphDataBuilder() {
        }

        public GlyphDataBuilder(GlyphData glyphData) {
            this.id = glyphData.id;
            this.textureName = glyphData.textureName;
            this.color = glyphData.color;
        }

        public ResourceLocation getTextureName() {
            return this.textureName;
        }

        public GlyphDataBuilder setTextureName(ResourceLocation textureName) {
            this.textureName = textureName;
            return this;
        }

        public float[] getColor() {
            return this.color;
        }

        public GlyphDataBuilder setColor(float[] color) {
            this.color = color;
            return this;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public GlyphDataBuilder setId(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public GlyphData build() {
            return new GlyphData(this.textureName, this.id, this.color[0], this.color[1], this.color[2], this.color[3]);
        }
    }
}

