/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item;

import com.hakimen.wandrous.client.model.DynamicTextureModel;
import com.hakimen.wandrous.common.item.DynamicModelled;
import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.item.component.WandDataComponent;
import com.hakimen.wandrous.common.registers.ContainerRegister;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.hakimen.wandrous.common.registers.EffectRegister;
import com.hakimen.wandrous.common.registers.GameRuleRegister;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.utils.CastingUtils;
import com.hakimen.wandrous.common.utils.ChargesUtils;
import com.hakimen.wandrous.common.utils.WandUtils;
import com.hakimen.wandrous.common.utils.data.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.joml.Math;

public class WandItem
extends Item
implements DynamicModelled {
    public WandItem() {
        super(new Item.Properties().stacksTo(1).component((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT));
    }

    public boolean isBarVisible(ItemStack pStack) {
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)pStack.get(DataComponentsRegister.WAND_COMPONENT);
        return stat.getMana() != stat.getMaxMana();
    }

    public int getBarWidth(ItemStack pStack) {
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)pStack.get(DataComponentsRegister.WAND_COMPONENT);
        return Math.round((float)((float)stat.getMana() * 13.0f / (float)stat.getMaxMana()));
    }

    public Component getName(ItemStack pStack) {
        return ((WandDataComponent.WandStat)pStack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).equals(WandDataComponent.DEFAULT_STAT) ? super.getName(pStack) : Component.literal((String)((WandDataComponent.WandStat)pStack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getName());
    }

    public int getBarColor(ItemStack pStack) {
        return 9492732;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)pStack.get(DataComponentsRegister.WAND_COMPONENT);
        if (!stat.equals(WandDataComponent.DEFAULT_STAT)) {
            pTooltipComponents.add((Component)Component.literal((String)"WAND_STATS_MARKER"));
            pTooltipComponents.add((Component)Component.literal((String)"WAND_SPELLS_MARKER"));
        } else {
            pTooltipComponents.add((Component)Component.literal((String)"Put in inventory to initialize"));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 200;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, final Player pPlayer, final InteractionHand pUsedHand) {
        if (pPlayer.isShiftKeyDown()) {
            MenuProvider containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return WandItem.this.getName(pPlayer.getItemInHand(pUsedHand));
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return ((MenuType)ContainerRegister.WAND_TINKER_MENU.get()).create(windowId, playerInventory);
                }
            };
            pPlayer.openMenu(containerProvider);
        } else if (!pLevel.isClientSide()) {
            pPlayer.startUsingItem(pUsedHand);
        }
        return InteractionResultHolder.success((Object)pPlayer.getItemInHand(pUsedHand));
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack wand, int pRemainingUseDuration) {
        if (pLivingEntity instanceof Player) {
            Player pPlayer = (Player)pLivingEntity;
            if (!pLevel.isClientSide && wand.getItem() instanceof WandItem && !pPlayer.hasContainerOpen() && ((WandDataComponent.WandStat)wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getWandCooldown() <= 0) {
                if (pPlayer.hasEffect(EffectRegister.SILENCE)) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"item.wandrous.wand.silenced"), true);
                    return;
                }
                CastingUtils castingUtils = new CastingUtils();
                Optional<ItemStackHandler> handler = Optional.ofNullable((ItemStackHandler)wand.getCapability(Capabilities.ItemHandler.ITEM));
                ArrayList<SpellStack> effect = new ArrayList<SpellStack>();
                handler.ifPresent(iItemHandler -> {
                    iItemHandler.deserializeNBT((HolderLookup.Provider)pPlayer.level().registryAccess(), ((WandDataComponent.WandStat)wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getInventory());
                    for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                        ItemStack stack = iItemHandler.getStackInSlot(i);
                        if (!(stack.getItem() instanceof SpellEffectItem)) continue;
                        effect.add(SpellStack.fromItemStack(stack));
                    }
                });
                if (effect.size() != ((WandDataComponent.WandStat)wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getCastableSize()) {
                    wand.update((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT, wandStat -> new WandDataComponent.WandStatBuilder((WandDataComponent.WandStat)wandStat).setCurrentIdx(0).setCastableSize(effect.size()).build());
                }
                int getOldIdx = ((WandDataComponent.WandStat)wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getCurrentIdx();
                if (effect.isEmpty()) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"item.wandrous.wand.empty_wand"), true);
                    return;
                }
                List<SpellStack> stackList = effect.subList(getOldIdx, effect.size());
                Node<SpellStack> cast = castingUtils.makeCastingTree(stackList, effect);
                float rechargeSpeed = ((WandDataComponent.WandStat)wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getRechargeSpeed();
                float castDelay = ((WandDataComponent.WandStat)wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getCastDelay();
                if (cast.getData() != null && cast.getData().getEffect() != null) {
                    int current = (getOldIdx + castingUtils.idx) % effect.size();
                    wand.update((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT, wandStat -> new WandDataComponent.WandStatBuilder((WandDataComponent.WandStat)wandStat).setCurrentIdx(current).build());
                    int cost = pPlayer.isCreative() && pLevel.getGameRules().getBoolean(GameRuleRegister.RULE_CREATIVE_CASTING) ? 0 : CastingUtils.calculateManaCost(cast);
                    float delayMod = CastingUtils.calculateCastDelayMod(cast);
                    float rechargeSpeedMod = CastingUtils.calculateRechargeSpeedMod(cast);
                    int currentMana = ((WandDataComponent.WandStat)wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getMana();
                    if (cost <= currentMana) {
                        castingUtils.toConsumeCharges.forEach(ChargesUtils::loseCharge);
                        handler.ifPresent(iItemHandler -> wand.update((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT, wandStat -> new WandDataComponent.WandStatBuilder((WandDataComponent.WandStat)wandStat).setInventory(iItemHandler.serializeNBT((HolderLookup.Provider)pLevel.registryAccess())).build()));
                        CastingUtils.castSpells((Entity)pPlayer, wand, pLevel, pPlayer.getEyePosition(), cast);
                        wand.update((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT, wandStat -> new WandDataComponent.WandStatBuilder((WandDataComponent.WandStat)wandStat).setMana(currentMana - Math.max((int)cost, (int)0)).setWandCooldown((int)((current == 0 ? rechargeSpeed + rechargeSpeedMod : castDelay + delayMod) * 20.0f)).setMaxCooldown((int)((current == 0 ? rechargeSpeed + rechargeSpeedMod : castDelay + delayMod) * 20.0f)).setFromCastDelay(current != 0).build());
                    } else {
                        pPlayer.displayClientMessage((Component)Component.translatable((String)"item.wandrous.wand.no_mana"), true);
                    }
                }
            }
        }
        super.onUseTick(pLevel, pLivingEntity, wand, pRemainingUseDuration);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (((WandDataComponent.WandStat)pStack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).equals(WandDataComponent.DEFAULT_STAT)) {
            WandUtils.makeWand(pStack);
        }
        if (((WandDataComponent.WandStat)pStack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getWandCooldown() >= 0) {
            pStack.update((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT, wandStat -> new WandDataComponent.WandStatBuilder((WandDataComponent.WandStat)wandStat).setWandCooldown(Math.max((int)0, (int)(wandStat.getWandCooldown() - 1))).build());
        }
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)pStack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get());
        int mana = stat.getMana();
        int maxMana = stat.getMaxMana();
        int manaRegen = stat.getManaChargeSpeed();
        if (mana <= maxMana) {
            int manaCost = (int)Math.clamp((float)0.0f, (float)maxMana, (float)((float)mana + (float)manaRegen / 20.0f));
            pStack.update((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT, wandStat -> new WandDataComponent.WandStatBuilder((WandDataComponent.WandStat)wandStat).setMana(manaCost).build());
        }
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        if (((WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).equals(WandDataComponent.DEFAULT_STAT)) {
            WandUtils.makeWand(stack);
        }
        return stack;
    }

    public ItemStack getNonInitializedInstance() {
        return new ItemStack((ItemLike)this);
    }

    @Override
    public DynamicTextureModel makeModel(ItemStack stack) {
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get());
        int gem = stat.getGem();
        int wand = stat.getWand();
        DynamicTextureModel model = DynamicTextureModel.fromTextures(List.of(ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"item/wand/gems/gem_%s".formatted(gem)), ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"item/wand/wands/wand_%s".formatted(wand))), ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"wand")).setDisplay("{ \"ground\": {\"rotation\": [0, 0, 0],\"translation\": [0, 3, 0],\"scale\":[ 1,1,1 ]}, \"thirdperson_righthand\":{\"rotation\":[0,90,50],\"translation\":[0,10,2.5],\"scale\":[2,2,1]},\"thirdperson_lefthand\":{\"rotation\":[0,-90,-50],\"translation\":[0,10,2.5],\"scale\":[2,2,1]},\"firstperson_righthand\":{\"rotation\":[0,90,35],\"translation\":[0,5,0],\"scale\":[1.25,1.25,0.8]},\"firstperson_lefthand\":{\"rotation\":[0,-90,-35],\"translation\":[0,5,0],\"scale\":[1.25,1.25,0.8]}}").setStack(stack);
        return model;
    }
}

