/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item;

import com.hakimen.wandrous.common.item.component.SpellCastsDataComponent;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStatus;
import com.hakimen.wandrous.common.utils.ChargesUtils;
import com.hakimen.wandrous.config.ServerConfig;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class SpellEffectItem
extends Item {
    Supplier<SpellEffect> spellEffect;

    public SpellEffectItem(Supplier<SpellEffect> spellEffect) {
        super(new Item.Properties().stacksTo(1));
        this.spellEffect = spellEffect;
    }

    public SpellEffectItem(Supplier<SpellEffect> spellEffect, int maxCasts) {
        super(new Item.Properties().stacksTo(1).component((DataComponentType)DataComponentsRegister.CHARGES_COMPONENT.get(), (Object)new SpellCastsDataComponent.SpellCastsData(maxCasts, maxCasts)));
        this.spellEffect = spellEffect;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.DARK_GRAY})));
        SpellStatus status = this.spellEffect.get().getStatus();
        pTooltipComponents.add((Component)Component.literal((String)" "));
        if (status.getRawDamage() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Damage %s".formatted((int)status.getRawDamage())));
        }
        if (status.getManaDrain() != 0) {
            pTooltipComponents.add((Component)Component.literal((String)"Mana Cost %s".formatted(status.getManaDrain())));
        }
        if (status.getSpeed() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Speed %.2f".formatted(Float.valueOf(status.getSpeed()))));
        }
        if (status.getSpread() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Spread %.2f".formatted(Float.valueOf(status.getSpread()))));
        }
        if (status.getLifeTime() != 0) {
            pTooltipComponents.add((Component)Component.literal((String)"Lifetime %.2fs".formatted(Float.valueOf((float)status.getLifeTime() / 20.0f))));
        }
        if (status.getRadius() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Radius %.2f".formatted(Float.valueOf(status.getRadius()))));
        }
        if (status.getSpeedMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Speed Modifier %s".formatted(status.getSpeedMod() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getSpeedMod())) : "%.2f".formatted(Float.valueOf(status.getSpeedMod())))));
        }
        if (status.getSpreadMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Spread Modifier %s".formatted(status.getSpreadMod() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getSpreadMod())) : "%.2f".formatted(Float.valueOf(status.getSpreadMod())))));
        }
        if (status.getCastDelayMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Cast Delay Modifier %s".formatted(status.getCastDelayMod() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getCastDelayMod())) : "%.2f".formatted(Float.valueOf(status.getCastDelayMod())))));
        }
        if (status.getRechargeTimeMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Recharge Time Modifier %s".formatted(status.getRechargeTimeMod() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getRechargeTimeMod())) : "%.2f".formatted(Float.valueOf(status.getRechargeTimeMod())))));
        }
        if (status.getDamageMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Damage Modifier %s".formatted(status.getDamageMod() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getDamageMod())) : "%.2f".formatted(Float.valueOf(status.getDamageMod())))));
        }
        if (status.getCritChance() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Crit Chance %s".formatted(status.getCritChance() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getCritChance())) : "%.2f".formatted(Float.valueOf(status.getCritChance())))));
        }
        if (status.getLifetimeMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Lifetime Mod %s".formatted(status.getLifetimeMod() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getLifetimeMod())) : "%.2f".formatted(Float.valueOf(status.getLifetimeMod())))));
        }
        if (status.getRadiusMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"Radius Mod %s".formatted(status.getRadiusMod() > 0.0f ? "+%.2f".formatted(Float.valueOf(status.getRadiusMod())) : "%.2f".formatted(Float.valueOf(status.getRadiusMod())))));
        }
        if (status.getiFrameTimeMod() != 0.0f) {
            pTooltipComponents.add((Component)Component.literal((String)"I-Frame Mod %s".formatted(status.getiFrameTimeMod() > 0.0f ? "-%.2f".formatted(Float.valueOf(status.getiFrameTimeMod())) : "%.2f".formatted(Float.valueOf(status.getiFrameTimeMod())))));
            pTooltipComponents.add((Component)Component.literal((String)("  -  Applies to : " + ((ServerConfig.IFrameConfig)((Object)ServerConfig.IFRAME_CONFIG.get())).name())).withStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GRAY})));
        }
        if (ChargesUtils.hasCharge(pStack)) {
            pTooltipComponents.add((Component)Component.literal((String)"Charges (%s/%s)".formatted(ChargesUtils.currentCharges(pStack), ChargesUtils.maxCharges(pStack))));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public SpellEffect getSpellEffect() {
        return this.spellEffect.get();
    }

    public SpellEffectItem setSpellEffect(Supplier<SpellEffect> spellEffect) {
        this.spellEffect = spellEffect;
        return this;
    }
}

