/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item;

import com.hakimen.wandrous.common.data.Scroll;
import com.hakimen.wandrous.common.data.ScrollDataListener;
import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.item.component.ScrollDataComponent;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.hakimen.wandrous.common.registers.EffectRegister;
import com.hakimen.wandrous.common.registers.ItemRegister;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.utils.CastingUtils;
import com.hakimen.wandrous.common.utils.data.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.Level;

public class ScrollItem
extends Item {
    public ScrollItem() {
        super(new Item.Properties().stacksTo(1).component((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get(), (Object)ScrollDataComponent.DEFAULT).durability(4));
    }

    public boolean isFoil(ItemStack pStack) {
        return true;
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (((ScrollDataComponent.ScrollData)pStack.get((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get())).equals(ScrollDataComponent.DEFAULT)) {
            ScrollItem.makeScroll(pStack);
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pPlayer.getCooldowns().isOnCooldown((Item)this) && !pLevel.isClientSide) {
            if (pPlayer.hasEffect(EffectRegister.SILENCE)) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"item.wandrous.wand.silenced"), true);
                return InteractionResultHolder.fail((Object)pPlayer.getItemInHand(pUsedHand));
            }
            ItemStack stack = pPlayer.getItemInHand(pUsedHand);
            ScrollDataComponent.ScrollData data = (ScrollDataComponent.ScrollData)stack.get((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get());
            ArrayList<SpellStack> effects = new ArrayList<SpellStack>();
            for (String spell : data.getSpells()) {
                Item effect = (Item)((Registry)ItemRegister.ITEMS.getRegistry().get()).get(ResourceLocation.parse((String)spell));
                if (effect == null || !(effect instanceof SpellEffectItem)) continue;
                SpellEffectItem sei = (SpellEffectItem)effect;
                effects.add(SpellStack.fromItemStack(sei.getDefaultInstance()));
            }
            CastingUtils castingUtils = new CastingUtils();
            Node<SpellStack> castingTree = castingUtils.makeCastingTree(effects, effects);
            if (castingTree.getData() != null) {
                CastingUtils.castSpells((Entity)pPlayer, stack, pLevel, pPlayer.getEyePosition(), castingTree);
                pPlayer.getCooldowns().addCooldown((Item)this, 80);
                stack.hurtAndBreak(1, (LivingEntity)pPlayer, EquipmentSlot.MAINHAND);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.fail((Object)pPlayer.getItemInHand(pUsedHand));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (pStack.getDamageValue() != 0) {
            pTooltipComponents.add((Component)Component.literal((String)"WAND_SPELLS_MARKER"));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public Component getName(ItemStack pStack) {
        if (((ScrollDataComponent.ScrollData)pStack.get((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get())).equals(ScrollDataComponent.DEFAULT)) {
            return super.getName(pStack);
        }
        MutableComponent named = Component.translatable((String)((ScrollDataComponent.ScrollData)pStack.get((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get())).getName());
        if (pStack.getDamageValue() == 0) {
            named = Component.translatable((String)((ScrollDataComponent.ScrollData)pStack.get((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get())).getName()).withStyle(ChatFormatting.OBFUSCATED);
        }
        return named;
    }

    public static void makeScroll(ItemStack stack) {
        Random r = new Random();
        Scroll scroll = ScrollDataListener.getAllScrolls().get(r.nextInt(0, ScrollDataListener.getAllScrolls().size()));
        ScrollItem.makeScroll(stack, scroll);
    }

    public static void makeScroll(ItemStack stack, Scroll scroll) {
        stack.update((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get(), (Object)((ScrollDataComponent.ScrollData)stack.get((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get())), scrollData -> new ScrollDataComponent.ScrollDataBuilder((ScrollDataComponent.ScrollData)scrollData).setName(scroll.getName()).setSpells(scroll.getSpells()).build());
        stack.set(DataComponents.LORE, (Object)new ItemLore(scroll.getLore().stream().map(s -> Component.literal((String)s)).toList()));
    }
}

