/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item;

import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.item.WandItem;
import com.hakimen.wandrous.common.item.component.WandDataComponent;
import com.hakimen.wandrous.common.particle.ArcaneKnowledgeParticle;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.hakimen.wandrous.common.registers.ItemRegister;
import com.hakimen.wandrous.common.registers.SoundRegister;
import com.hakimen.wandrous.common.utils.ChargesUtils;
import com.hakimen.wandrous.config.ServerConfig;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.ItemStackHandler;

public class RechargeItem
extends Item {
    RechargeTier tier;

    public RechargeItem(int uses) {
        super(new Item.Properties().durability(uses));
    }

    public RechargeItem(Item.Properties props) {
        super(props);
    }

    public RechargeItem(int uses, RechargeTier tier) {
        this(uses);
        this.tier = tier;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return switch (this.tier.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Integer)ServerConfig.RECHARGE_CRYSTAL.get();
            case 1 -> (Integer)ServerConfig.GREATER_RECHARGE_CRYSTAL.get();
        };
    }

    public boolean isValidRepairItem(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.getItem().equals(ItemRegister.TEALESTITE_SHARD.get());
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        if (this.getDamage(itemstack) != this.getMaxDamage(itemstack)) {
            pPlayer.startUsingItem(pUsedHand);
        } else {
            pPlayer.displayClientMessage((Component)Component.literal((String)"Out of charges"), true);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.getInventory().items.stream().filter(stack -> stack.getItem() instanceof WandItem).forEach(stack -> {
                Optional<ItemStackHandler> handler = Optional.ofNullable((ItemStackHandler)stack.getCapability(Capabilities.ItemHandler.ITEM));
                handler.ifPresent(itemHandler -> {
                    itemHandler.deserializeNBT((HolderLookup.Provider)pLevel.registryAccess(), ((WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getInventory());
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack spellStack = itemHandler.getStackInSlot(i);
                        if (!(spellStack.getItem() instanceof SpellEffectItem) || !ChargesUtils.hasCharge(spellStack) || !ChargesUtils.hasSpentCharges(spellStack)) continue;
                        ChargesUtils.regainAllCharges(spellStack);
                    }
                    stack.update((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)WandDataComponent.DEFAULT_STAT, wandStat -> new WandDataComponent.WandStatBuilder((WandDataComponent.WandStat)wandStat).setInventory(itemHandler.serializeNBT((HolderLookup.Provider)pLevel.registryAccess())).build());
                });
            });
            player.getInventory().items.stream().filter(stack -> stack.getItem() instanceof SpellEffectItem && ChargesUtils.hasCharge(stack) && ChargesUtils.hasSpentCharges(stack)).forEach(ChargesUtils::regainAllCharges);
            BlockPos blockPos = player.getOnPos();
            SoundEvent soundEvent = (SoundEvent)SoundRegister.RECHARGE.get();
            pLevel.playSound(player, blockPos, soundEvent, SoundSource.PLAYERS, 1.0f, (switch (this.tier.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 1.0f;
                case 1 -> 0.75f;
            }) + new Random().nextFloat(-0.15f, 0.15f));
            pStack.setDamageValue(pStack.getDamageValue() + 1);
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pLevel.isClientSide()) {
            pLevel.addParticle((ParticleOptions)new ArcaneKnowledgeParticle.ArcaneKnowledgeParticleOptions(0.0f, 1.0f, 0.68f), 1.0 + pLivingEntity.getX() + pLevel.random.triangle(-1.0, 1.0), 1.0 + pLivingEntity.getY() + pLevel.random.triangle(-1.0, 2.0), 1.0 + pLivingEntity.getZ() + pLevel.random.triangle(-1.0, 1.0), 0.001, 0.001, 0.001);
        }
    }

    public SoundEvent getBreakingSound() {
        return (SoundEvent)SoundRegister.RECHARGE.get();
    }

    public static enum RechargeTier {
        CRYSTAL,
        GREATER_CRYSTAL;

    }
}

