/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.item;

import com.hakimen.wandrous.common.data.Glyph;
import com.hakimen.wandrous.common.item.component.InscribedLensDataComponent;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.hakimen.wandrous.common.utils.GlyphUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class InscribedLensItem
extends Item {
    public InscribedLensItem() {
        super(new Item.Properties().durability(16).component((DataComponentType)DataComponentsRegister.GLYPH_COMPONENT.get(), (Object)InscribedLensDataComponent.DEFAULT));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (GlyphUtils.hasGlyph(pStack) && !GlyphUtils.isDefault(pStack)) {
            pTooltipComponents.add((Component)Component.literal((String)"GLYPH_MARKER"));
            pTooltipComponents.add((Component)Component.translatable((String)GlyphUtils.getLangKey(pStack)).withStyle(ChatFormatting.DARK_GRAY));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public static ItemStack makeGlyphStack(ItemStack stack, Glyph data) {
        stack.update((DataComponentType)DataComponentsRegister.GLYPH_COMPONENT.get(), (Object)InscribedLensDataComponent.DEFAULT, glyphData -> new InscribedLensDataComponent.GlyphDataBuilder((InscribedLensDataComponent.GlyphData)glyphData).setId(data.getId()).setTextureName(data.getTexture()).setColor(data.getColor()).build());
        return stack;
    }
}

