/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.events;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="wandrous")
public class VillagerTradesEvent {
    @SubscribeEvent
    public static void onVillagerTradesEvent(net.neoforged.neoforge.event.village.VillagerTradesEvent event) {
        if (event.getType().equals((Object)VillagerProfession.CARTOGRAPHER)) {
            event.getTrades().put(3, List.of(new TreasureMapForEmeralds(20, (TagKey<Structure>)TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"dungeon/dungeon")), "wandrous.filled_map.dungeon", (Holder<MapDecorationType>)MapDecorationTypes.TARGET_X, 12, 5)));
        }
    }

    static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final Holder<MapDecorationType> destinationType;
        private final int maxUses;
        private final int villagerXp;

        public TreasureMapForEmeralds(int pEmeraldCost, TagKey<Structure> pDestination, String pDisplayName, Holder<MapDecorationType> pDestinationType, int pMaxUses, int pVillagerXp) {
            this.emeraldCost = pEmeraldCost;
            this.destination = pDestination;
            this.displayName = pDisplayName;
            this.destinationType = pDestinationType;
            this.maxUses = pMaxUses;
            this.villagerXp = pVillagerXp;
        }

        @Nullable
        public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
            if (!(pTrader.level() instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)pTrader.level();
            BlockPos blockpos = serverlevel.findNearestMapStructure(this.destination, pTrader.blockPosition(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.create((Level)serverlevel, (int)blockpos.getX(), (int)blockpos.getZ(), (byte)2, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", this.destinationType);
                itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.displayName));
                itemstack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"wandrous.map.dungeon.lore"))));
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }
}

