/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.static_spell;

import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.utils.CastingUtils;
import com.hakimen.wandrous.common.utils.data.Node;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TriggeringGlyphEntity
extends Entity {
    List<ItemStack> effects;
    public static final EntityDataAccessor<Integer> MAX_TICK_TIME = SynchedEntityData.defineId(TriggeringGlyphEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(TriggeringGlyphEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(TriggeringGlyphEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public int maxTickTime;
    public float radius;
    public UUID owner;
    public ItemStack wand;

    public TriggeringGlyphEntity(EntityType<?> pEntityType, Level pLevel, List<SpellStack> spells, int maxTickTime, float radius, UUID owner, ItemStack wand) {
        super(pEntityType, pLevel);
        this.effects = spells.stream().map(SpellStack::getReferenceStack).toList();
        this.maxTickTime = maxTickTime;
        this.radius = radius;
        this.owner = owner;
        this.wand = wand;
        this.entityData.set(MAX_TICK_TIME, (Object)maxTickTime);
        this.entityData.set(RADIUS, (Object)Float.valueOf(radius));
        this.entityData.set(OWNER, Optional.ofNullable(owner));
    }

    public TriggeringGlyphEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.effects = List.of();
        this.maxTickTime = Integer.MAX_VALUE;
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 2 == 0 && !this.level().isClientSide) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            Entity owner = serverLevel.getEntity(this.owner);
            AABB trigger = AABB.ofSize((Vec3)this.getPosition(0.0f), (double)1.0, (double)1.0, (double)1.0).inflate((double)this.radius, 1.0, (double)this.radius);
            List<LivingEntity> didTrigger = serverLevel.getEntitiesOfClass(LivingEntity.class, trigger).stream().filter(livingEntity -> livingEntity != owner).toList();
            if (!didTrigger.isEmpty()) {
                for (int i = 0; i < didTrigger.size(); ++i) {
                    LivingEntity entity = didTrigger.get(i);
                    if (!(entity.distanceTo((Entity)this) <= this.radius)) continue;
                    CastingUtils utils = new CastingUtils();
                    List<SpellStack> stackList = this.effects.stream().map(SpellStack::fromItemStack).toList();
                    Node<SpellStack> cast = utils.makeCastingTree(stackList, stackList);
                    if (cast.getData() != null) {
                        CastingUtils.castSpells(owner, this.wand, this.level(), didTrigger.get(i).getPosition(0.0f), cast, context -> context.setCastPositionModified(true).getHit().add(entity));
                    }
                    this.discard();
                    break;
                }
            }
        }
        if (this.tickCount >= this.maxTickTime) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(MAX_TICK_TIME, (Object)this.maxTickTime);
        pBuilder.define(RADIUS, (Object)Float.valueOf(this.radius));
        pBuilder.define(OWNER, Optional.ofNullable(this.owner));
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        ArrayList<ItemStack> spellEffects = new ArrayList<ItemStack>();
        for (Tag t : pCompound.getList("effects", 8)) {
            Pair tag = (Pair)ItemStack.SIMPLE_ITEM_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)t).getOrThrow();
            spellEffects.add((ItemStack)tag.getFirst());
        }
        this.effects = spellEffects;
        this.owner = pCompound.getUUID("owner");
        this.wand = (ItemStack)((Pair)ItemStack.SIMPLE_ITEM_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)pCompound.get("wand")).getOrThrow()).getFirst();
        this.maxTickTime = pCompound.getInt("maxTickTime");
        this.radius = pCompound.getFloat("radius");
        this.entityData.set(MAX_TICK_TIME, (Object)this.maxTickTime);
        this.entityData.set(RADIUS, (Object)Float.valueOf(this.radius));
        this.entityData.set(OWNER, Optional.ofNullable(this.owner));
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        ListTag tag = new ListTag();
        for (ItemStack effect : this.effects) {
            tag.add((Object)((Tag)ItemStack.SIMPLE_ITEM_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)effect).getOrThrow()));
        }
        pCompound.put("effects", (Tag)tag);
        pCompound.putUUID("owner", this.owner);
        pCompound.put("wand", (Tag)ItemStack.SIMPLE_ITEM_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.wand).getOrThrow());
        pCompound.putInt("maxTickTime", this.maxTickTime);
        pCompound.putFloat("radius", this.radius);
    }
}

