/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.static_spell;

import com.hakimen.wandrous.common.registers.SoundRegister;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TimerEntity
extends Entity {
    public static final EntityDataAccessor<Integer> MAX_TICK_TIME = SynchedEntityData.defineId(TimerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int maxTickTime;

    public TimerEntity(EntityType<?> pEntityType, Level pLevel, int maxTickTime) {
        super(pEntityType, pLevel);
        this.maxTickTime = maxTickTime;
        this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        this.entityData.set(MAX_TICK_TIME, (Object)maxTickTime);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(MAX_TICK_TIME, (Object)this.maxTickTime);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.maxTickTime = compoundTag.getInt("MaxTickTime");
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("MaxTickTime", this.maxTickTime);
    }

    public void tick() {
        super.tick();
        if (this.tickCount < 2 || this.tickCount % 40 == 0 && this.tickCount + 40 <= this.maxTickTime) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)SoundRegister.TIMER_SPELL.get(), SoundSource.NEUTRAL, 0.6f, 1.0f);
        }
        if (this.tickedEnough()) {
            this.level().playSound(null, this.getOnPos(), SoundEvents.BEACON_DEACTIVATE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.discard();
        }
    }

    public boolean tickedEnough() {
        return this.maxTickTime != -1 && this.tickCount > this.maxTickTime;
    }
}

