/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.static_spell;

import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.registers.DamageTypeRegister;
import com.hakimen.wandrous.common.registers.EntityRegister;
import com.hakimen.wandrous.common.registers.ParticleRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import com.hakimen.wandrous.common.utils.CastingUtils;
import com.hakimen.wandrous.common.utils.RaycastUtils;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlasmaBeamEntity
extends SpellCastingProjectile {
    BlockPos breaking;
    float blockDestroyProgress;

    public PlasmaBeamEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.movers = new ArrayList();
        this.maxTicks = Integer.MAX_VALUE;
    }

    public PlasmaBeamEntity(Vec3 location, Level level, SpellContext context, ISpellMover ... movers) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.PLASMA_BEAM.get()), level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.setNoGravity(true);
        this.setXRot(context.getCaster().getXRot());
        this.setYRot(context.getCaster().getYRot());
        this.setPos(location);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = new ArrayList();
        this.movers.addAll(Arrays.stream(movers).toList());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    public PlasmaBeamEntity(double pX, double pY, double pZ, Level level, SpellContext context) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.PLASMA_BEAM.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.setNoGravity(true);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = PlasmaBeamEntity.getMovers(this.context.getNode());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        block13: {
            if (this.context == null) break block13;
            for (ISpellMover mover : this.movers) {
                mover.move(this.context, this);
            }
            where = this.context.isCastPositionModified() != false ? this.context.getLocation() : this.context.getCaster().getEyePosition();
            caster = this.context.getCaster();
            if (this.tickCount % 20 == 0) {
                this.context.getLevel().playSound(null, this.context.getCaster().getOnPos(), SoundEvents.BEACON_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            i = 0;
            while ((float)i < this.context.getStatus().getRadius() * 2.0f) {
                result = RaycastUtils.raycastRotatedAtPos(caster, where, Vec3.ZERO, this.context.getStatus().getRadius(), 0.0f);
                level = (ServerLevel)this.context.getLevel();
                if (!(result instanceof BlockHitResult)) ** GOTO lbl-1000
                bhr = (BlockHitResult)result;
                if (result.getType() != HitResult.Type.MISS) {
                    state = level.getBlockState(bhr.getBlockPos());
                    blockHardness = state.getDestroySpeed((BlockGetter)level, bhr.getBlockPos()) * 100.0f;
                    breakSpeed = this.context.getStatus().getDamage() / 2.0f;
                    this.breaking = bhr.getBlockPos();
                    this.blockDestroyProgress = Math.clamp(this.blockDestroyProgress + breakSpeed / blockHardness, 1.0f, 10.0f);
                    if (this.breaking == bhr.getBlockPos()) {
                        level.destroyBlockProgress(this.hashCode(), this.breaking, (int)this.blockDestroyProgress);
                    }
                    if (this.blockDestroyProgress >= 10.0f) {
                        level.destroyBlock(this.breaking, false);
                        this.blockDestroyProgress = 0.0f;
                        this.breaking = null;
                    }
                } else if (result instanceof EntityHitResult && (var9_11 = (ehr = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
                    target = (LivingEntity)var9_11;
                    target.hurt(DamageTypeRegister.beam(this.context.getOriginalCaster()), this.context.getStatus().getDamage());
                    CastingUtils.iFrameApply((Entity)target, this.context);
                }
                if (this.tickCount % 5 == 0) {
                    j = 0;
                    while ((float)j < this.context.getStatus().getRadius() && !AABB.ofSize((Vec3)(loc = where.add(off = caster.getViewVector(0.0f).scale((double)j))), (double)2.0, (double)2.0, (double)2.0).contains(result.getLocation())) {
                        level.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegister.CHAIN_SHOT.get()), loc.x, loc.y, loc.z, 1, 0.1, 0.1, 0.1, 0.10000000149011612);
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.tickCount > this.maxTicks) {
            var2_2 = this.level();
            if (var2_2 instanceof ServerLevel) {
                serverLevel = (ServerLevel)var2_2;
                if (this.breaking != null) {
                    serverLevel.destroyBlockProgress(this.hashCode(), this.breaking, -1);
                }
            }
            this.discard();
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putInt("ticks", this.tickCount);
        pCompound.putInt("maxTicks", this.maxTicks);
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.tickCount = pCompound.getInt("ticks");
        this.maxTicks = pCompound.getInt("maxTicks");
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
    }
}

