/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.static_spell;

import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.registers.DamageTypeRegister;
import com.hakimen.wandrous.common.registers.EntityRegister;
import com.hakimen.wandrous.common.registers.ParticleRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.utils.CastingUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class NukeEntity
extends SpellCastingProjectile {
    public static final EntityDataAccessor<Integer> MAX_TICK_TIME = SynchedEntityData.defineId(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int maxTickTime;
    public SpellContext context;

    public NukeEntity(Level pLevel, int maxTickTime, Vec3 location, SpellContext context) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.NUKE_ENTITY.get()), pLevel);
        this.maxTickTime = maxTickTime;
        this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        this.setNoGravity(true);
        this.context = context.clone();
        this.setPos(location);
        this.entityData.set(MAX_TICK_TIME, (Object)maxTickTime);
        ServerLevel lvl = (ServerLevel)context.getLevel();
        for (ServerPlayer player : lvl.players()) {
            if (!(player.distanceTo((Entity)this) <= 512.0f)) continue;
            lvl.sendParticles(player, (ParticleOptions)((SimpleParticleType)ParticleRegister.SHOCKWAVE.get()), true, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    public NukeEntity(Level pLevel, int maxTickTime, Vec3 location) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.NUKE_ENTITY.get()), pLevel);
        this.maxTickTime = maxTickTime;
        this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        this.setNoGravity(true);
        this.setPos(location);
        this.entityData.set(MAX_TICK_TIME, (Object)maxTickTime);
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(MAX_TICK_TIME, (Object)this.maxTickTime);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.maxTickTime = compoundTag.getInt("MaxTickTime");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("MaxTickTime", this.maxTickTime);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && (float)this.tickCount / (float)this.maxTickTime >= 0.25f) {
            Level level = this.level();
            BlockPos pos = this.getOnPos();
            Vec3 location = this.getPosition(0.0f);
            float radius = ((float)this.tickCount / (float)this.maxTickTime - 0.25f) * 50.0f;
            Random r = new Random();
            List entityList = level.getEntities(EntityTypeTest.forClass(LivingEntity.class), AABB.ofSize((Vec3)location, (double)(radius * 2.0f), (double)(radius * 2.0f), (double)(radius * 2.0f)), entity -> entity instanceof LivingEntity);
            for (LivingEntity livingEntity : entityList) {
                livingEntity.hurt(DamageTypeRegister.nuke(this.context.getOriginalCaster()), 10.0f);
                livingEntity.invulnerableTime = 10;
                CastingUtils.iFrameApply((Entity)livingEntity, this.context);
            }
            Iterator positions = BlockPos.betweenClosedStream((BlockPos)pos.offset((int)radius, (int)radius, (int)radius), (BlockPos)pos.offset((int)(-radius), (int)(-radius), (int)(-radius))).filter(blockPos -> !level.getBlockState(blockPos).is(Blocks.AIR) && blockPos.closerToCenterThan((Position)location, (double)(radius + r.nextFloat(-1.0f, 1.0f))) && level.getBlockState(blockPos).getDestroySpeed((BlockGetter)level, blockPos) != -1.0f && level.getBlockState(blockPos).getPistonPushReaction() != PushReaction.BLOCK).iterator();
            if (this.tickedEnough()) {
                if (EventHooks.canEntityGrief((Level)level, (Entity)this)) {
                    while (positions.hasNext()) {
                        blockpos = (BlockPos)positions.next();
                        if ((double)r.nextFloat() < 0.7 && !level.getBlockState(blockpos).is(Blocks.FIRE)) {
                            level.setBlock(blockpos, Blocks.NETHERRACK.defaultBlockState(), 3);
                        }
                        if ((double)r.nextFloat() < 0.5 && !level.getBlockState(blockpos).is(Blocks.FIRE)) {
                            level.setBlock(blockpos, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
                        }
                        if (level.getBlockState(blockpos.above()).getDestroySpeed((BlockGetter)level, blockpos) == -1.0f || !(r.nextFloat() < 0.2f)) continue;
                        level.setBlock(blockpos.above(), Blocks.FIRE.defaultBlockState(), 3);
                    }
                }
                this.discard();
            } else if (EventHooks.canEntityGrief((Level)level, (Entity)this)) {
                while (positions.hasNext()) {
                    blockpos = (BlockPos)positions.next();
                    level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }

    public boolean tickedEnough() {
        return this.maxTickTime != -1 && this.tickCount > this.maxTickTime;
    }
}

