/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.static_spell;

import com.hakimen.wandrous.common.registers.EntityRegister;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChainPrisonEntity
extends Entity {
    LivingEntity target;
    public static final EntityDataAccessor<Integer> MAX_TICK_TIME = SynchedEntityData.defineId(ChainPrisonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> TARGET_BB_HEIGHT = SynchedEntityData.defineId(ChainPrisonEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public int maxTickTime;

    public ChainPrisonEntity(EntityType<?> pEntityType, Level pLevel) {
        super((EntityType)EntityRegister.CHAIN_PRISON.get(), pLevel);
        this.maxTickTime = 1000;
        this.target = null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(MAX_TICK_TIME, (Object)this.maxTickTime);
        pBuilder.define(TARGET_BB_HEIGHT, (Object)Float.valueOf(0.0f));
    }

    public ChainPrisonEntity(Level pLevel, int maxTickTime, LivingEntity target) {
        super((EntityType)EntityRegister.CHAIN_PRISON.get(), pLevel);
        this.maxTickTime = maxTickTime;
        this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        this.setNoGravity(true);
        this.target = target;
        this.setPos(target.getX(), target.getY(), target.getZ());
        this.entityData.set(MAX_TICK_TIME, (Object)maxTickTime);
        this.entityData.set(TARGET_BB_HEIGHT, (Object)Float.valueOf(target.getBbHeight()));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.maxTickTime = compoundTag.getInt("MaxTickTime");
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("MaxTickTime", this.maxTickTime);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.target != null && this.target.isAlive()) {
                this.target.fallDistance = 0.0f;
                this.target.teleportTo(this.getPosition(0.0f).x(), this.getPosition(0.0f).y(), this.getPosition(0.0f).z());
            } else {
                this.discard();
            }
            if (this.tickedEnough()) {
                this.discard();
            }
        }
    }

    public boolean tickedEnough() {
        return this.maxTickTime != -1 && this.tickCount > this.maxTickTime;
    }
}

