/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.projectiles;

import com.hakimen.wandrous.common.registers.SpellMoverRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.SpellEffect;
import com.hakimen.wandrous.common.spell.SpellStack;
import com.hakimen.wandrous.common.spell.effects.modifiers.MoverSpellEffect;
import com.hakimen.wandrous.common.spell.effects.modifiers.ProjectileHitEffect;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import com.hakimen.wandrous.common.utils.CastingUtils;
import com.hakimen.wandrous.common.utils.data.Node;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.joml.Vector3fc;

public class SpellCastingProjectile
extends ThrowableProjectile {
    public static final EntityDataAccessor<CompoundTag> MOVER_DATA = SynchedEntityData.defineId(SpellCastingProjectile.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public int maxTicks;
    public SpellContext context;
    public List<ISpellMover> movers;

    public CompoundTag moverListToNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.movers == null) {
            this.movers = new ArrayList<ISpellMover>();
        }
        ListTag list = new ListTag();
        this.movers.forEach(iSpellMover -> list.add((Object)StringTag.valueOf((String)((Registry)SpellMoverRegister.MOVERS.getRegistry().get()).getKey(iSpellMover).toString())));
        tag.put("movers", (Tag)list);
        return tag;
    }

    public static List<ISpellMover> NBTToMoverList(CompoundTag tag) {
        ListTag list = tag.getList("movers", 8);
        ArrayList<ISpellMover> movers = new ArrayList<ISpellMover>();
        list.forEach(tag1 -> movers.add((ISpellMover)((Registry)SpellMoverRegister.MOVERS.getRegistry().get()).get(ResourceLocation.parse((String)tag1.getAsString()))));
        return movers;
    }

    protected SpellCastingProjectile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected SpellCastingProjectile(EntityType<? extends ThrowableProjectile> pEntityType, double pX, double p_37458_, double pY, Level p_37460_) {
        super(pEntityType, pX, p_37458_, pY, p_37460_);
    }

    protected SpellCastingProjectile(EntityType<? extends ThrowableProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    protected static void onHitBlock(Projectile self, BlockHitResult pResult, SpellContext context) {
        List<ProjectileHitEffect> effects = SpellCastingProjectile.addProjectileEffects(context.getNode());
        effects.forEach(projectileHitEffect -> projectileHitEffect.onHitBlock(context, self.level(), pResult.getBlockPos(), self.level().getBlockState(pResult.getBlockPos())));
        if (context.getNode().getData().getEffect().hasAnyOf(1, 4)) {
            self.setDeltaMovement(new Vec3(self.getDeltaMovement().toVector3f().reflect((Vector3fc)Vec3.atLowerCornerOf((Vec3i)pResult.getDirection().getNormal()).toVector3f())));
            self.lookAt(EntityAnchorArgument.Anchor.EYES, self.getEyePosition().add(self.getDeltaMovement()));
            SpellContext context1 = context.clone();
            CastingUtils.clearMods(context1);
            context.getNode().getChildren().forEach(child -> ((SpellStack)child.getData()).getEffect().cast(context1.setNode((Node<SpellStack>)child).setLocation(pResult.getLocation())));
        }
    }

    protected static void onHitEntity(Projectile self, EntityHitResult pResult, SpellContext context) {
        Entity entity = pResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            context.getHit().add(entity2);
        }
        List<ProjectileHitEffect> effects = SpellCastingProjectile.addProjectileEffects(context.getNode());
        effects.forEach(projectileHitEffect -> {
            projectileHitEffect.onHitBlock(context, self.level(), pResult.getEntity().getOnPos(), self.level().getBlockState(pResult.getEntity().getOnPos()));
            projectileHitEffect.onHitEntity(context, pResult.getEntity());
        });
        if (context.getNode().getData().getEffect().hasAnyOf(1, 4)) {
            self.setDeltaMovement(self.getDeltaMovement().multiply(1.0, -1.0, 1.0));
            self.lookAt(EntityAnchorArgument.Anchor.EYES, self.getEyePosition().add(self.getDeltaMovement()));
            SpellContext context1 = context.clone();
            CastingUtils.clearMods(context1);
            context.getNode().getChildren().forEach(child -> ((SpellStack)child.getData()).getEffect().cast(context.clone().setNode((Node<SpellStack>)child).setLocation(pResult.getLocation())));
        }
        pResult.getEntity().hurt(self.damageSources().source(DamageTypes.MAGIC, context.getOriginalCaster()), context.getStatus().getDamage());
        CastingUtils.iFrameApply(pResult.getEntity(), context);
    }

    protected static boolean shouldCollide(Projectile self, EntityHitResult pResult, SpellContext context) {
        return !pResult.getEntity().equals((Object)context.getOriginalCaster()) && !pResult.getEntity().getType().equals(self.getType()) || context.isCanHitCaster();
    }

    protected static void onTimeEnd(Projectile self, SpellContext context) {
        if (context.getNode().getData().getEffect().hasKind(4)) {
            CastingUtils.clearMods(context);
            context.getNode().getChildren().forEach(child -> ((SpellStack)child.getData()).getEffect().cast(context.setNode((Node<SpellStack>)child).setLocation(self.getPosition(0.0f))));
        }
    }

    private static List<ProjectileHitEffect> addProjectileEffects(Node<SpellStack> node) {
        ArrayList<ProjectileHitEffect> effects = new ArrayList<ProjectileHitEffect>();
        if (node.getParent() != null && node.getParent().getData().getEffect().hasKind(2)) {
            SpellEffect effect = node.getParent().getData().getEffect();
            if (effect instanceof ProjectileHitEffect) {
                ProjectileHitEffect eff = (ProjectileHitEffect)effect;
                effects.add(eff);
            }
            effects.addAll(SpellCastingProjectile.addProjectileEffects(node.getParent()));
        }
        return effects;
    }

    public static List<ISpellMover> getMovers(Node<SpellStack> node) {
        ArrayList<ISpellMover> movers = new ArrayList<ISpellMover>();
        if (node.getParent() != null && node.getParent().getData().getEffect().hasKind(2)) {
            SpellEffect effect = node.getParent().getData().getEffect();
            if (effect instanceof MoverSpellEffect) {
                MoverSpellEffect eff = (MoverSpellEffect)effect;
                movers.add(eff.getMover());
            }
            movers.addAll(SpellCastingProjectile.getMovers(node.getParent()));
        }
        return movers;
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putInt("MaxTicks", this.maxTicks);
        super.addAdditionalSaveData(pCompound);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        this.maxTicks = pCompound.getInt("MaxTicks");
        super.readAdditionalSaveData(pCompound);
    }

    public float getInertia() {
        return 0.0f;
    }

    public float getFluidInertia() {
        return 0.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(MOVER_DATA, (Object)new CompoundTag());
    }

    public void tick() {
        float f;
        HitResult hitresult;
        super.tick();
        if (this.tickCount % 4 == 0) {
            List entities = this.level().getEntities((Entity)this, AABB.ofSize((Vec3)this.getPosition(0.0f), (double)1.0, (double)1.0, (double)1.0));
            for (Entity entity : entities) {
                this.onHitEntity(new EntityHitResult(entity, this.getEyePosition()));
            }
        }
        if ((hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f1 = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            f = this.getFluidInertia();
        } else {
            f = this.getInertia();
        }
        this.setDeltaMovement(vec3.scale((double)f));
        this.applyGravity();
        this.setPos(d0, d1, d2);
        this.lookAt(EntityAnchorArgument.Anchor.EYES, this.getEyePosition().add(this.getDeltaMovement()));
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }
}

