/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.projectiles;

import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.registers.EntityRegister;
import com.hakimen.wandrous.common.registers.ParticleRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class GlimmeringBoltProjectile
extends SpellCastingProjectile {
    public GlimmeringBoltProjectile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.movers = new ArrayList();
    }

    public GlimmeringBoltProjectile(double pX, double pY, double pZ, Level level, SpellContext context, ISpellMover ... movers) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.GLIMMERING_BOLT_PROJECTILE.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = new ArrayList();
        this.movers.addAll(Arrays.stream(movers).toList());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    public GlimmeringBoltProjectile(double pX, double pY, double pZ, Level level, SpellContext context) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.GLIMMERING_BOLT_PROJECTILE.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = GlimmeringBoltProjectile.getMovers(this.context.getNode());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            for (int i = 0; i < 32; ++i) {
                Random r = new Random();
                this.level().addParticle((ParticleOptions)ParticleRegister.GLIMMERING_BOLT_HIT.get(), this.getX(), this.getY(), this.getZ(), (double)r.nextFloat(-1.0f, 1.0f), 1.0, (double)r.nextFloat(-1.0f, 1.0f));
            }
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        if (this.context != null) {
            this.context.getLevel().broadcastEntityEvent((Entity)this, (byte)3);
            SpellCastingProjectile.onHitBlock((Projectile)this, pResult, this.context);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (this.context != null) {
            if (!this.context.isPiercing()) {
                if (SpellCastingProjectile.shouldCollide((Projectile)this, pResult, this.context)) {
                    this.context.getLevel().broadcastEntityEvent((Entity)this, (byte)3);
                    SpellCastingProjectile.onHitEntity((Projectile)this, pResult, this.context);
                    this.discard();
                }
            } else if (SpellCastingProjectile.shouldCollide((Projectile)this, pResult, this.context)) {
                SpellCastingProjectile.onHitEntity((Projectile)this, pResult, this.context);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.context != null) {
            for (ISpellMover mover : this.movers) {
                mover.move(this.context, this);
            }
        }
        if (!this.level().isClientSide && this.tickCount > this.maxTicks) {
            if (this.context != null && this.context.getNode().getData().getEffect().hasKind(4)) {
                this.context.getStatus().setLifetimeMod(0.0f);
                SpellCastingProjectile.onTimeEnd((Projectile)this, this.context);
            }
            this.discard();
        }
    }

    @Override
    public float getInertia() {
        return 0.98f;
    }

    @Override
    public float getFluidInertia() {
        return 0.9f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putInt("ticks", this.tickCount);
        pCompound.putInt("maxTicks", this.maxTicks);
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.tickCount = pCompound.getInt("ticks");
        this.maxTicks = pCompound.getInt("maxTicks");
    }
}

