/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.projectiles;

import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.registers.EntityRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ChainShotProjectile
extends SpellCastingProjectile {
    int hitCount;
    List<LivingEntity> hit;

    public ChainShotProjectile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.movers = new ArrayList();
        this.hit = new ArrayList<LivingEntity>();
    }

    public ChainShotProjectile(double pX, double pY, double pZ, Level level, SpellContext context, ISpellMover ... movers) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.CHAIN_SHOT.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.setNoGravity(true);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = new ArrayList();
        this.movers.addAll(Arrays.stream(movers).toList());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
        this.hit = new ArrayList<LivingEntity>();
    }

    public ChainShotProjectile(double pX, double pY, double pZ, Level level, SpellContext context) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.CHAIN_SHOT.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.setNoGravity(true);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = new ArrayList();
        this.hit = new ArrayList<LivingEntity>();
        this.movers = ChainShotProjectile.getMovers(this.context.getNode());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public ChainShotProjectile setHitCount(int hitCount) {
        this.hitCount = hitCount;
        return this;
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            Random r = new Random();
            for (int i = 0; i < 16; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX() - 0.5 + (double)r.nextFloat(-1.0f, 1.0f), this.getY() - 0.5 + (double)r.nextFloat(-1.0f, 1.0f), this.getZ() - 0.5 + (double)r.nextFloat(-1.0f, 1.0f), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        if (this.context != null) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            SpellCastingProjectile.onHitBlock((Projectile)this, pResult, this.context);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (this.context != null && SpellCastingProjectile.shouldCollide((Projectile)this, pResult, this.context)) {
            LivingEntity livingEntity;
            Entity entity;
            SpellCastingProjectile.onHitEntity((Projectile)this, pResult, this.context);
            if (this.hitCount > 0 && (entity = pResult.getEntity()) instanceof LivingEntity && !this.hit.contains(livingEntity = (LivingEntity)entity)) {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.hit.add(livingEntity);
                this.level().playSound(null, this.context.getCaster().getOnPos(), SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.PLAYERS, 1.0f, 1.0f + (float)this.hit.size() / 10.0f);
                this.context.setHomingTarget(null);
                --this.hitCount;
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.context != null) {
            List<ISpellMover> movers = ChainShotProjectile.getMovers(this.context.getNode());
            for (ISpellMover mover : movers) {
                mover.move(this.context, this);
            }
            if (this.context.getHomingTarget() == null) {
                Level level = this.context.getLevel();
                Vec3 pos = this.getPosition(0.0f);
                float radius = this.context.getStatus().getRadius();
                List entities = level.getEntities(this.context.getCaster(), AABB.ofSize((Vec3)pos, (double)radius, (double)radius, (double)radius), entity -> entity instanceof LivingEntity && !entity.equals((Object)this.context.getOriginalCaster()) && !this.hit.contains(entity));
                LivingEntity closest = null;
                float closestDist = Float.MAX_VALUE;
                for (Entity entity2 : entities) {
                    if (closest == null) {
                        closest = (LivingEntity)entity2;
                        closestDist = (float)closest.position().distanceTo(this.getPosition(0.0f).subtract(0.0, closest.getEyeY() / 2.0, 0.0));
                        continue;
                    }
                    if (!((double)closestDist >= entity2.position().distanceTo(this.getPosition(0.0f).subtract(0.0, closest.getEyeY() / 2.0, 0.0)))) continue;
                    closest = (LivingEntity)entity2;
                    closestDist = (float)closest.position().distanceTo(this.getPosition(0.0f).subtract(0.0, closest.getEyeY() / 2.0, 0.0));
                }
                if (closest != null) {
                    this.context.setHomingTarget(closest);
                }
            }
            if (this.context.getHomingTarget() != null) {
                LivingEntity target = this.context.getHomingTarget();
                if (target.isAlive()) {
                    this.setDeltaMovement(target.getEyePosition().subtract(this.getPosition(0.0f)).normalize().scale((double)this.context.getStatus().getSpeed()));
                } else {
                    this.context.setHomingTarget(null);
                }
            }
        }
        if (!(this.level().isClientSide || this.tickCount <= this.maxTicks && this.hitCount != 0)) {
            if (this.context != null && this.context.getNode().getData().getEffect().hasKind(4)) {
                this.context.getStatus().setLifetimeMod(0.0f);
                this.context.getHit().addAll(this.hit);
                SpellCastingProjectile.onTimeEnd((Projectile)this, this.context);
                this.level().playSound(null, this.context.getCaster().getOnPos(), SoundEvents.AMETHYST_CLUSTER_HIT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.discard();
        }
    }

    @Override
    public float getInertia() {
        return 1.0f;
    }

    @Override
    public float getFluidInertia() {
        return 1.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putInt("maxTicks", this.maxTicks);
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.maxTicks = pCompound.getInt("maxTicks");
    }
}

