/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.projectiles;

import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.payloads.PositionalScreenShakePacket;
import com.hakimen.wandrous.common.registers.EntityRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class BombProjectile
extends SpellCastingProjectile {
    float damage;

    public BombProjectile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.movers = new ArrayList();
        this.damage = 1.0f;
    }

    public BombProjectile(double pX, double pY, double pZ, Level level, SpellContext context, ISpellMover ... movers) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.BOMB.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = new ArrayList();
        this.damage = this.context.getStatus().getDamage();
        this.movers.addAll(Arrays.stream(movers).toList());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    public BombProjectile(double pX, double pY, double pZ, Level level, SpellContext context) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.BOMB.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.damage = this.context.getStatus().getDamage();
        this.movers = BombProjectile.getMovers(context.getNode());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            // empty if block
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        if (this.context != null) {
            SpellCastingProjectile.onHitBlock((Projectile)this, pResult, this.context);
            this.consume();
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (this.context != null) {
            if (!this.context.isPiercing()) {
                this.context.getLevel().broadcastEntityEvent((Entity)this, (byte)3);
                if (SpellCastingProjectile.shouldCollide((Projectile)this, pResult, this.context)) {
                    SpellCastingProjectile.onHitEntity((Projectile)this, pResult, this.context);
                    this.consume();
                    this.discard();
                }
            } else if (SpellCastingProjectile.shouldCollide((Projectile)this, pResult, this.context)) {
                SpellCastingProjectile.onHitEntity((Projectile)this, pResult, this.context);
                this.consume();
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.context != null) {
            for (ISpellMover mover : this.movers) {
                mover.move(this.context, this);
            }
        }
        if (!this.level().isClientSide && this.tickCount > this.maxTicks) {
            this.consume();
            this.discard();
        }
    }

    private void consume() {
        Level level = this.level();
        if (EventHooks.canEntityGrief((Level)level, (Entity)this)) {
            float radius = this.damage;
            PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)this.position().x, (double)this.position().y, (double)this.position().z, (double)50.0, (CustomPacketPayload)new PositionalScreenShakePacket(1.5f, 20, 40, this.getPosition(0.0f).toVector3f(), 50.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            level.explode((Entity)this, this.getX(), this.getY(), this.getZ(), radius, Level.ExplosionInteraction.NONE);
        }
    }

    @Override
    public float getInertia() {
        return 0.98f;
    }

    @Override
    public float getFluidInertia() {
        return 0.9f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putInt("maxTicks", this.maxTicks);
        pCompound.putFloat("Damage", this.damage);
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.maxTicks = pCompound.getInt("maxTicks");
        this.damage = pCompound.getFloat("Damage");
    }
}

