/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.entity.projectiles;

import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.registers.EntityRegister;
import com.hakimen.wandrous.common.spell.SpellContext;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlackHoleProjectile
extends SpellCastingProjectile {
    public BlackHoleProjectile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.movers = new ArrayList();
    }

    public BlackHoleProjectile(double pX, double pY, double pZ, Level level, SpellContext context, ISpellMover ... movers) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.BLACK_HOLE_PROJECTILE.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.setNoGravity(true);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = new ArrayList();
        this.movers.addAll(Arrays.stream(movers).toList());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    public BlackHoleProjectile(double pX, double pY, double pZ, Level level, SpellContext context) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegister.BLACK_HOLE_PROJECTILE.get()), pX, pY, pZ, level);
        this.context = context.clone();
        this.context.setCaster((Entity)this);
        this.setNoGravity(true);
        this.maxTicks = this.context.getStatus().getLifeTime();
        this.movers = BlackHoleProjectile.getMovers(this.context.getNode());
        this.entityData.set(MOVER_DATA, (Object)this.moverListToNBT());
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            Random r = new Random();
            for (int i = 0; i < 20; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX() + (double)r.nextFloat(-2.0f, 2.0f), this.getY() + (double)r.nextFloat(-2.0f, 2.0f), this.getZ() + (double)r.nextFloat(-2.0f, 2.0f), 0.0, (double)-0.01f, 0.0);
            }
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
    }

    protected void onHitEntity(EntityHitResult pResult) {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.context != null) {
            for (ISpellMover mover : this.movers) {
                mover.move(this.context, this);
            }
            BlockPos pos = this.getOnPos();
            Vec3 location = this.getPosition(0.0f);
            Level level = this.level();
            float radius = this.context.getStatus().getRadius();
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset((int)(-radius), (int)(-radius), (int)(-radius)), (BlockPos)pos.offset((int)radius, (int)radius, (int)radius))) {
                BlockState state;
                if (!blockpos.closerToCenterThan((Position)location, (double)radius) || level.isClientSide || (state = level.getBlockState(blockpos)).getDestroySpeed((BlockGetter)level, blockpos) == -1.0f) continue;
                level.setBlockAndUpdate(blockpos, Blocks.AIR.defaultBlockState());
            }
        }
        if (!this.level().isClientSide && this.tickCount > this.maxTicks) {
            if (this.context != null && this.context.getNode().getData().getEffect().hasKind(4)) {
                this.context.getStatus().setLifetimeMod(0.0f);
                SpellCastingProjectile.onTimeEnd((Projectile)this, this.context);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    @Override
    public float getInertia() {
        return 1.0f;
    }

    @Override
    public float getFluidInertia() {
        return 1.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putInt("ticks", this.tickCount);
        pCompound.putInt("maxTicks", this.maxTicks);
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.tickCount = pCompound.getInt("ticks");
        this.maxTicks = pCompound.getInt("maxTicks");
    }
}

