/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.datagen;

import com.hakimen.wandrous.common.data.Glyph;
import com.hakimen.wandrous.common.datagen.recipes.ArcaneInscriberRecipeBuilder;
import com.hakimen.wandrous.common.item.InscribedLensItem;
import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.registers.GlyphRegister;
import com.hakimen.wandrous.common.registers.ItemRegister;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider {
    static List<Glyph> TRIGGER = List.of((Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.CONTROL.get());
    static List<Glyph> TIMER = List.of((Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.FOCUS.get());

    public RecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        this.arcaneInscriberRecipes(pRecipeOutput);
        this.craftingTableRecipes(pRecipeOutput);
    }

    public void craftingTableRecipes(RecipeOutput pRecipeOutput) {
        ItemStack stack = ((InscribedLensItem)((Object)ItemRegister.INSCRIBED_LENS.get())).getDefaultInstance();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.BIND.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.CHAIN).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "bind_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.CONTROL.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "control_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.DESTINY.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "destiny_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.FOCUS.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "focus_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.GUIDANCE.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.REDSTONE).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "guidance_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.KNOWLEDGE.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.BOOK).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "knowledge_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.MIND.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "mind_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.NEW.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.PAPER).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "new_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.POWER.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.GUNPOWDER).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "power_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.TINKER.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.REPEATER).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "tinker_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.VITALITY.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "vitality_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)InscribedLensItem.makeGlyphStack(stack.copy(), (Glyph)GlyphRegister.WEAVE.get())).pattern(" - ").pattern("+x+").pattern(" - ").define(Character.valueOf('+'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), (ItemLike)Items.STRING).define(Character.valueOf('x'), Tags.Items.GLASS_PANES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.GLASS_PANE), RecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save(pRecipeOutput, "weave_lens");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegister.ARCANE_INSCRIBER.get())).pattern("+-+").pattern("+++").define(Character.valueOf('-'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('+'), Tags.Items.INGOTS_IRON).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get()))).save(pRecipeOutput, "arcane_inscriber");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegister.GLYPH_PROJECTOR.get())).pattern("+-+").pattern("+y+").pattern("+,+").define(Character.valueOf('y'), () -> ItemRegister.TEALESTITE_CLUSTER.get()).define(Character.valueOf(','), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('-'), Tags.Items.GLASS_PANES).define(Character.valueOf('+'), Tags.Items.INGOTS_IRON).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get()))).save(pRecipeOutput, "glyph_projector");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegister.TEALESTITE_RECHARGE_CRYSTAL.get())).pattern(" + ").pattern("+y+").pattern(" + ").define(Character.valueOf('y'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('+'), Tags.Items.NUGGETS_GOLD).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get()))).save(pRecipeOutput, "recharge_crystal");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegister.TEALESTITE_GREATER_RECHARGE_CRYSTAL.get())).pattern("x+ ").pattern("+y+").pattern(" +x").define(Character.valueOf('y'), () -> ItemRegister.TEALESTITE_RECHARGE_CRYSTAL.get()).define(Character.valueOf('x'), () -> ItemRegister.TEALESTITE_SHARD.get()).define(Character.valueOf('+'), Tags.Items.NUGGETS_GOLD).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get()))).save(pRecipeOutput, "greater_recharge_crystal");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS.get())).requires((ItemLike)ItemRegister.CHERT_BRICKS.get()).requires((ItemLike)Items.VINE).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()))).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.VINE), RecipeProvider.has((ItemLike)Items.VINE)).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_TILES.get())).requires((ItemLike)ItemRegister.CHERT_TILES.get()).requires((ItemLike)Items.VINE).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get()))).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.VINE), RecipeProvider.has((ItemLike)Items.VINE)).save(pRecipeOutput);
        RecipeProvider.stairBuilder((ItemLike)((ItemLike)ItemRegister.CHERT_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.CHERT.get()})).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT.get()))).save(pRecipeOutput);
        RecipeProvider.stairBuilder((ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.POLISHED_CHERT.get()})).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT.get()))).save(pRecipeOutput);
        RecipeProvider.stairBuilder((ItemLike)((ItemLike)ItemRegister.CHERT_TILES_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.CHERT_TILES.get()})).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get()))).save(pRecipeOutput);
        RecipeProvider.stairBuilder((ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.CHERT_BRICKS.get()})).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()))).save(pRecipeOutput);
        RecipeProvider.stairBuilder((ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.MOSSY_CHERT_BRICKS.get()})).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS.get()))).save(pRecipeOutput);
        RecipeProvider.stairBuilder((ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_TILES_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.MOSSY_CHERT_TILES.get()})).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_TILES.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_TILES.get()))).save(pRecipeOutput);
        RecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT.get()));
        RecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_TILES_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get()));
        RecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()));
        RecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS.get()));
        RecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_TILES_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_TILES.get()));
        RecipeProvider.wall((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_WALL.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.wall((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_WALL.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()));
        RecipeProvider.wall((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS_WALL.get()), (ItemLike)((ItemLike)ItemRegister.MOSSY_CHERT_BRICKS.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHISELED_CHERT_BRICKS.get())).pattern("x").pattern("x").define(Character.valueOf('x'), () -> ItemRegister.CHERT_BRICKS_SLAB.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_SLAB.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_SLAB.get()))).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_PILLAR.get())).pattern("x").pattern("x").define(Character.valueOf('x'), () -> ItemRegister.CHERT_TILES_SLAB.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT_TILES_SLAB.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT_TILES_SLAB.get()))).save(pRecipeOutput);
        RecipeProvider.simpleCookingRecipe((RecipeOutput)pRecipeOutput, (String)"smelting", (RecipeSerializer)RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (int)100, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()), (ItemLike)((ItemLike)ItemRegister.CRACKED_CHERT_BRICKS.get()), (float)0.1f);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()), (int)2);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_STAIRS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_WALL.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()), (int)2);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT_STAIRS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHISELED_CHERT_BRICKS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()), (int)2);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_STAIRS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_WALL.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_TILES_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()), (int)2);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_TILES_STAIRS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT.get()), (int)2);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT_STAIRS.get()), (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_TILES_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get()), (int)2);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_TILES_STAIRS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_TILES.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHISELED_CHERT_BRICKS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_SLAB.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()), (int)2);
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_STAIRS.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()));
        RecipeProvider.stonecutterResultFromBase((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS_WALL.get()), (ItemLike)((ItemLike)ItemRegister.CHERT_BRICKS.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.TEALESTITE_BLOCK.get())).pattern("xx").pattern("xx").define(Character.valueOf('x'), () -> ItemRegister.TEALESTITE_SHARD.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.TEALESTITE_SHARD.get()))).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegister.POLISHED_CHERT.get()), (int)4).pattern("xx").pattern("xx").define(Character.valueOf('x'), () -> ItemRegister.CHERT.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)ItemRegister.CHERT.get())), RecipeProvider.has((ItemLike)((ItemLike)ItemRegister.CHERT.get()))).save(pRecipeOutput);
    }

    private void projectiles(RecipeOutput pRecipeOutput) {
        RecipeProvider.inscriberRecipe(pRecipeOutput, "glimmering_bolt", List.of((Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}), ((SpellEffectItem)((Object)ItemRegister.GLIMMERING_BOLT_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "trigger_glimmering_bolt", TRIGGER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.GLIMMERING_BOLT_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TRIGGER_GLIMMERING_BOLT_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "timer_glimmering_bolt", TIMER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.GLIMMERING_BOLT_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TIMER_GLIMMERING_BOLT_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "fireball", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CHARGE}), ((SpellEffectItem)((Object)ItemRegister.FIREBALL_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "trigger_fireball", TRIGGER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.FIREBALL_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TRIGGER_FIREBALL_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "timer_fireball", TIMER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.FIREBALL_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TIMER_FIREBALL_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "bomb", List.of((Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((SpellEffectItem)((Object)ItemRegister.BOMB_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "black_hole", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_EYE}), ((SpellEffectItem)((Object)ItemRegister.BLACK_HOLE_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "timer_black_hole", TIMER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.BLACK_HOLE_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TIMER_BLACK_HOLE_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "sonic_boom", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.VITALITY.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD}), ((SpellEffectItem)((Object)ItemRegister.SONIC_BOOM_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "trigger_sonic_boom", TRIGGER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.SONIC_BOOM_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TRIGGER_SONIC_BOOM_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "timer_sonic_boom", TIMER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.SONIC_BOOM_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TIMER_SONIC_BOOM_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "chain_shot", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.TEALESTITE_SHARD.get()}), ((SpellEffectItem)((Object)ItemRegister.CHAIN_SHOT_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "trigger_chain_shot", TRIGGER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.CHAIN_SHOT_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TRIGGER_CHAIN_SHOT_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "timer_chain_shot", TIMER, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.CHAIN_SHOT_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TIMER_CHAIN_SHOT_SPELL.get())).getDefaultInstance(), 100, 3);
    }

    private void staticProjectiles(RecipeOutput pRecipeOutput) {
        RecipeProvider.inscriberRecipe(pRecipeOutput, "explosion", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.TNT}), ((SpellEffectItem)((Object)ItemRegister.EXPLOSION_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "major_explosion", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.TNT}), ((SpellEffectItem)((Object)ItemRegister.MAJOR_EXPLOSION_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "gust", List.of((Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.WIND_CHARGE}), ((SpellEffectItem)((Object)ItemRegister.GUST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "lighting_bolt", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHTNING_ROD}), ((SpellEffectItem)((Object)ItemRegister.SUMMON_LIGHTING_BOLT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "plasma_beam", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_BLOCK}), ((SpellEffectItem)((Object)ItemRegister.PLASMA_BEAM.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "tnt_minecart", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.TNT_MINECART}), ((SpellEffectItem)((Object)ItemRegister.SUMMON_TNT_MINECART_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "chain_prison", List.of((Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHAIN}), ((SpellEffectItem)((Object)ItemRegister.CHAIN_PRISON_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "conjure_webs", List.of((Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), ((SpellEffectItem)((Object)ItemRegister.CONJURE_WEBS_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "conjure_light", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), ((SpellEffectItem)((Object)ItemRegister.CONJURE_LIGHT_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "conjure_block", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS), ((SpellEffectItem)((Object)ItemRegister.CONJURE_BLOCK_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "collect", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.HOPPER}), ((SpellEffectItem)((Object)ItemRegister.COLLECT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "smelt", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), ((SpellEffectItem)((Object)ItemRegister.SMELT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "teleport", List.of((Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), ((SpellEffectItem)((Object)ItemRegister.TELEPORT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "swap_teleport", List.of((Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), ((SpellEffectItem)((Object)ItemRegister.SWAP_TELEPORT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "homebringer_teleport", List.of((Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.NEW.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), ((SpellEffectItem)((Object)ItemRegister.HOME_BRINGER_TELEPORT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "drill", List.of((Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_PICKAXE}), ((SpellEffectItem)((Object)ItemRegister.DRILL_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "chainsaw", List.of((Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_AXE}), ((SpellEffectItem)((Object)ItemRegister.CHAINSAW_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "giga_drill", List.of((Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND_PICKAXE}), ((SpellEffectItem)((Object)ItemRegister.GIGA_DRILL_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "glyph_of_trigger", List.of((Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SENSOR}), ((SpellEffectItem)((Object)ItemRegister.GLYPH_OF_TRIGGERING.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "summon_bees", List.of((Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BLOCK}), ((SpellEffectItem)((Object)ItemRegister.SUMMON_BEE_SWARM_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "summon_wolfs", List.of((Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.NEW.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), ((SpellEffectItem)((Object)ItemRegister.SUMMON_WOLF_PACK_SPELL.get())).getDefaultInstance(), 100, 2);
    }

    private void movers(RecipeOutput pRecipeOutput) {
        RecipeProvider.inscriberRecipe(pRecipeOutput, "homing", List.of((Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_EYE}), ((SpellEffectItem)((Object)ItemRegister.HOMING_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "boomerang", List.of((Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.DESTINY.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SLIME_BALL}), ((SpellEffectItem)((Object)ItemRegister.BOOMERANG_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "guide", List.of((Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.DESTINY.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.LEAD}), ((SpellEffectItem)((Object)ItemRegister.GUIDE_SPELL.get())).getDefaultInstance(), 100, 2);
    }

    public void modifiers(RecipeOutput pRecipeOutput) {
        RecipeProvider.inscriberRecipe(pRecipeOutput, "small_delay_cast", List.of((Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.DESTINY.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLOCK}), ((SpellEffectItem)((Object)ItemRegister.SMALL_DELAY_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "medium_delay_cast", List.of((Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.SMALL_DELAY_CAST_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.MEDIUM_DELAY_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "big_delay_cast", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.MEDIUM_DELAY_CAST_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.BIG_DELAY_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "freezing_charge", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.PACKED_ICE}), ((SpellEffectItem)((Object)ItemRegister.FREEZING_CHARGE_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "igneous_charge", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGMA_BLOCK}), ((SpellEffectItem)((Object)ItemRegister.IGNEOUS_CHARGE_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "poison_charge", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.POISONOUS_POTATO}), ((SpellEffectItem)((Object)ItemRegister.POISON_CHARGE_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "crumbling_charge", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((SpellEffectItem)((Object)ItemRegister.CRUMBLING_CHARGE_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "accelerate", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), ((SpellEffectItem)((Object)ItemRegister.ACCELERATE_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "hexagon_cast", List.of((Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), ((SpellEffectItem)((Object)ItemRegister.HEXAGON_CAST_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "double_cast", List.of((Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHAIN}), ((SpellEffectItem)((Object)ItemRegister.DOUBLE_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "triple_cast", List.of((Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.DOUBLE_CAST_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TRIPLE_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "double_split_cast", List.of((Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.DOUBLE_CAST_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.DOUBLE_SPLIT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "triple_split_cast", List.of((Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.DOUBLE_SPLIT_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.TRIPLE_SPLIT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "quad_split_cast", List.of((Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.TRIPLE_SPLIT_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.QUAD_SPLIT_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "spread_cast", List.of((Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_VEIN}), ((SpellEffectItem)((Object)ItemRegister.SPREAD_CAST_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "add_mana", List.of((Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.HEART_OF_THE_SEA}), ((SpellEffectItem)((Object)ItemRegister.ADD_MANA_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "damage_plus", List.of((Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER}), ((SpellEffectItem)((Object)ItemRegister.DAMAGE_PLUS_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "critical_plus", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.DAMAGE_PLUS_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.CRITICAL_PLUS_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "light_shot", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER}), ((SpellEffectItem)((Object)ItemRegister.LIGHT_SHOT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "heavy_shot", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK}), ((SpellEffectItem)((Object)ItemRegister.HEAVY_SHOT_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "increase_lifetime", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLOCK}), ((SpellEffectItem)((Object)ItemRegister.INCREASE_LIFETIME_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "decrease_lifetime", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLOCK}), ((SpellEffectItem)((Object)ItemRegister.DECREASE_LIFETIME_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "increase_range", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.PISTON}), ((SpellEffectItem)((Object)ItemRegister.INCREASE_RANGE_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "decrease_range", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.PISTON}), ((SpellEffectItem)((Object)ItemRegister.DECREASE_RANGE_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "increase_spread", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.CONTROL.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_VEIN}), ((SpellEffectItem)((Object)ItemRegister.INCREASE_SPREAD_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "decrease_spread", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_VEIN}), ((SpellEffectItem)((Object)ItemRegister.DECREASE_SPREAD_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "heavy_spread", List.of((Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.POWER.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.INCREASE_SPREAD_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.HEAVY_SPREAD_SPELL.get())).getDefaultInstance(), 100, 1);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "decrease_recharge_time", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLOCK}), ((SpellEffectItem)((Object)ItemRegister.DECREASE_RECHARGE_TIME_SPELL.get())).getDefaultInstance(), 100, 4);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "health_to_power", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), ((SpellEffectItem)((Object)ItemRegister.HEALTH_TO_POWER_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "friends_to_power", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.VITALITY.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), ((SpellEffectItem)((Object)ItemRegister.FRIENDS_TO_POWER_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "piercing", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}), ((SpellEffectItem)((Object)ItemRegister.PIERCING_SPELL.get())).getDefaultInstance(), 100, 3);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "teleport_cast", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT}), ((SpellEffectItem)((Object)ItemRegister.TELEPORT_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "line_cast", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get(), (Glyph)GlyphRegister.BIND.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.TELEPORT_CAST_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.LINE_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "long_distance_cast", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.TELEPORT_CAST_SPELL.get()}), ((SpellEffectItem)((Object)ItemRegister.LONG_DISTANCE_CAST_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "faltering", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.DESTINY.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.KNOWLEDGE.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.CONTROL.get(), (Glyph)GlyphRegister.POWER.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get(), (Glyph)GlyphRegister.GUIDANCE.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.TOTEM_OF_UNDYING}), ((SpellEffectItem)((Object)ItemRegister.FALTERING_SPELL.get())).getDefaultInstance(), 100, 4);
    }

    private void raycasts(RecipeOutput pRecipeOutput) {
        RecipeProvider.inscriberRecipe(pRecipeOutput, "igneous_gaze", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), ((SpellEffectItem)((Object)ItemRegister.IGNEOUS_GAZE_SPELL.get())).getDefaultInstance(), 100, 2);
        RecipeProvider.inscriberRecipe(pRecipeOutput, "freezing_gaze", List.of((Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.WEAVE.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.FOCUS.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.MIND.get(), (Glyph)GlyphRegister.TINKER.get(), (Glyph)GlyphRegister.TINKER.get()), Ingredient.of((ItemLike[])new ItemLike[]{Items.SNOWBALL}), ((SpellEffectItem)((Object)ItemRegister.FREEZING_GAZE_SPELL.get())).getDefaultInstance(), 100, 2);
    }

    private void arcaneInscriberRecipes(RecipeOutput pRecipeOutput) {
        this.projectiles(pRecipeOutput);
        this.staticProjectiles(pRecipeOutput);
        this.modifiers(pRecipeOutput);
        this.movers(pRecipeOutput);
        this.raycasts(pRecipeOutput);
    }

    public static void inscriberRecipe(RecipeOutput out, String name, List<Glyph> glyphs, Ingredient onSlate, ItemStack output, int ticks, int tier) {
        ArcaneInscriberRecipeBuilder builder = new ArcaneInscriberRecipeBuilder().setGlyphs(glyphs).setOnSlate(onSlate).setTier(tier).setTicks(ticks).setOutput(output);
        builder.save(out, RecipeProvider.location(name));
    }

    private static ResourceLocation location(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)name);
    }
}

