/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.datagen;

import com.hakimen.wandrous.common.data.Glyph;
import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.registers.EffectRegister;
import com.hakimen.wandrous.common.registers.GlyphRegister;
import com.hakimen.wandrous.common.registers.ItemRegister;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class LangProvider
extends LanguageProvider {
    public LangProvider(PackOutput output) {
        super(output, "wandrous", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.wandrous.main", "Wandrous");
        this.add("itemGroup.wandrous.spells", "Wandrous: Spells");
        this.add("wandrous.filled_map.dungeon", "Dungeon Explorer Map");
        this.add("wandrous.map.dungeon.lore", "A map to a ancient dungeon told to hold some arcane secrets");
        this.add("item.wandrous.wand.silenced", "Silenced");
        this.add("item.wandrous.wand.empty_wand", "No spells to cast");
        this.add("item.wandrous.wand.no_mana", "Not enough mana to cast spells");
        this.add("key.wandrous.perks", "See Perks");
        this.add("jei.wandrous.category.arcane_inscribing", "Arcane Inscribing");
        this.addEffects();
        this.addSpells();
        this.addGlyphs();
        this.addItems();
        this.addDamageTypes();
        this.addToolTips();
    }

    public void addToolTips() {
        this.add("tooltip.wandrous.wand.cast_delay", "Cast Delay %.2fs");
        this.add("tooltip.wandrous.wand.recharge_time", "Recharge Speed %.2fs");
        this.add("tooltip.wandrous.wand.mana_max", "Mana Max %s");
        this.add("tooltip.wandrous.wand.current_mana", "Mana %s");
        this.add("tooltip.wandrous.wand.mana_charge_speed", "Mana Charge Speed %s");
        this.add("tooltip.wandrous.wand.capacatiy", "Capacity %s");
    }

    public void addDamageTypes() {
        this.add("death.attack.wandrous.slice", "%s was sliced by %s");
        this.add("death.attack.wandrous.nuke", "%s was nuked by %s");
        this.add("death.attack.wandrous.beam", "%s was disintegrated by %s");
    }

    public void addEffects() {
        this.add((MobEffect)EffectRegister.FREEZING.get(), "Freeze");
        this.add((MobEffect)EffectRegister.IGNITE.get(), "Ignite");
        this.add((MobEffect)EffectRegister.SCALE_DOWN.get(), "Scale down");
        this.add((MobEffect)EffectRegister.SCALE_UP.get(), "Scale up");
        this.add((MobEffect)EffectRegister.SILENCE.get(), "Silence");
    }

    public void addGlyphs() {
        this.addGlyph((Glyph)GlyphRegister.BIND.get(), "Bind");
        this.addGlyph((Glyph)GlyphRegister.CONTROL.get(), "Control");
        this.addGlyph((Glyph)GlyphRegister.DESTINY.get(), "Destiny");
        this.addGlyph((Glyph)GlyphRegister.FOCUS.get(), "Focus");
        this.addGlyph((Glyph)GlyphRegister.GUIDANCE.get(), "Guidance");
        this.addGlyph((Glyph)GlyphRegister.KNOWLEDGE.get(), "Knowledge");
        this.addGlyph((Glyph)GlyphRegister.MIND.get(), "Mind");
        this.addGlyph((Glyph)GlyphRegister.NEW.get(), "New");
        this.addGlyph((Glyph)GlyphRegister.POWER.get(), "Power");
        this.addGlyph((Glyph)GlyphRegister.TINKER.get(), "Tinker");
        this.addGlyph((Glyph)GlyphRegister.VITALITY.get(), "Vitality");
        this.addGlyph((Glyph)GlyphRegister.WEAVE.get(), "Weave");
    }

    public void addItems() {
        this.add((Item)ItemRegister.WAND.get(), "Wand");
        this.add((Item)ItemRegister.SCROLL.get(), "Magic Scroll");
        this.add((Item)ItemRegister.INSCRIBED_LENS.get(), "Inscribed Lens");
        this.add((Item)ItemRegister.CHERT.get(), "Chert");
        this.add((Item)ItemRegister.CHERT_SLAB.get(), "Chert Slab");
        this.add((Item)ItemRegister.CHERT_STAIRS.get(), "Chert Stairs");
        this.add((Item)ItemRegister.CHERT_WALL.get(), "Chert Wall");
        this.add((Item)ItemRegister.POLISHED_CHERT.get(), "Polished Chert");
        this.add((Item)ItemRegister.POLISHED_CHERT_SLAB.get(), "Polished Chert Slab");
        this.add((Item)ItemRegister.POLISHED_CHERT_STAIRS.get(), "Polished Chert Stairs");
        this.add((Item)ItemRegister.CHERT_BRICKS.get(), "Chert Bricks");
        this.add((Item)ItemRegister.CHISELED_CHERT_BRICKS.get(), "Chiseled Chert Bricks");
        this.add((Item)ItemRegister.CRACKED_CHERT_BRICKS.get(), "Cracked Chert Bricks");
        this.add((Item)ItemRegister.CHERT_BRICKS_SLAB.get(), "Chert Brick Slab");
        this.add((Item)ItemRegister.CHERT_BRICKS_STAIRS.get(), "Chert Brick Stairs");
        this.add((Item)ItemRegister.CHERT_BRICKS_WALL.get(), "Chert Brick Wall");
        this.add((Item)ItemRegister.MOSSY_CHERT_BRICKS.get(), "Mossy Chert Bricks");
        this.add((Item)ItemRegister.MOSSY_CHERT_BRICKS_SLAB.get(), "Mossy Chert Brick Slab");
        this.add((Item)ItemRegister.MOSSY_CHERT_BRICKS_STAIRS.get(), "Mossy Chert Brick Stairs");
        this.add((Item)ItemRegister.MOSSY_CHERT_BRICKS_WALL.get(), "Mossy Chert Brick Wall");
        this.add((Item)ItemRegister.CHERT_PILLAR.get(), "Chert Pillar");
        this.add((Item)ItemRegister.CHERT_TILES.get(), "Chert Tiles");
        this.add((Item)ItemRegister.CHERT_TILES_STAIRS.get(), "Chert Tile Stairs");
        this.add((Item)ItemRegister.CHERT_TILES_SLAB.get(), "Chert Tile Slab");
        this.add((Item)ItemRegister.MOSSY_CHERT_TILES.get(), "Mossy Chert Tiles");
        this.add((Item)ItemRegister.MOSSY_CHERT_TILES_STAIRS.get(), "Mossy Chert Tiles Stairs");
        this.add((Item)ItemRegister.MOSSY_CHERT_TILES_SLAB.get(), "Mossy Chert Tiles Slab");
        this.add((Item)ItemRegister.TEALESTITE_BLOCK.get(), "Tealestite Block");
        this.add((Item)ItemRegister.BUDDING_TEALESTITE.get(), "Budding Tealestite");
        this.add((Item)ItemRegister.SMALL_TEALESTITE_BUD.get(), "Small Tealestite Bud");
        this.add((Item)ItemRegister.MEDIUM_TEALESTITE_BUD.get(), "Medium Tealestite Bud");
        this.add((Item)ItemRegister.LARGE_TEALESTITE_BUD.get(), "Large Tealestite Bud");
        this.add((Item)ItemRegister.TEALESTITE_CLUSTER.get(), "Tealestite Cluster");
        this.add((Item)ItemRegister.TEALESTITE_SHARD.get(), "Tealestite Shard");
        this.add((Item)ItemRegister.TEALESTITE_RECHARGE_CRYSTAL.get(), "Tealestite Recharging Crystal");
        this.add((Item)ItemRegister.TEALESTITE_GREATER_RECHARGE_CRYSTAL.get(), "Greater Tealestite Recharging Crystal");
        this.add((Item)ItemRegister.ARCANE_INSCRIBER.get(), "Arcane Inscriber");
        this.add((Item)ItemRegister.GLYPH_PROJECTOR.get(), "Glyph Projector");
    }

    public void addSpells() {
        this.addSpell((SpellEffectItem)((Object)ItemRegister.NUKE_SPELL.get()), "Nuke", "How'd you get your hands in this...");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.PLASMA_BEAM.get()), "Plasma Beam", "An sudden and violent beam of radiant light");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BOMB_SPELL.get()), "Bomb", "Throws a bomb that damages foes");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GIGA_DRILL_SPELL.get()), "Giga Drill", "Bigger and therefore better (ROW ROW FIGHT THE POWER !!)");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DRILL_SPELL.get()), "Drill", "It drills!");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CHAINSAW_SPELL.get()), "Chainsaw", "A good way to get rid of trees");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.COLLECT_SPELL.get()), "Collect", "Collects items and teleports them to the caster");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SMELT_SPELL.get()), "Smelt", "Smelts an item");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.EXPLOSION_SPELL.get()), "Explosion", "A small explosion");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.MAJOR_EXPLOSION_SPELL.get()), "Major Explosion", "A large explosion");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BLACK_HOLE_SPELL.get()), "Black Hole", "A slow orb of void that consumes blocks");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TIMER_BLACK_HOLE_SPELL.get()), "Black Hole with Timer", "A slow orb of void that consumes blocks and casts a spell once it expires");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SONIC_BOOM_SPELL.get()), "Sonic Boom", "A sonically charged shriek");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TIMER_SONIC_BOOM_SPELL.get()), "Sonic Boom with Timer", "A sonically charged shriek that casts a spell once it expires");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_SONIC_BOOM_SPELL.get()), "Sonic Boom with Trigger", "A sonically charged shriek that casts a spell upon collision");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GLIMMERING_BOLT_SPELL.get()), "Glimmering Bolt", "A shiny arcane projectile");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TIMER_GLIMMERING_BOLT_SPELL.get()), "Glimmering Bolt with Timer", "A shiny arcane projectile that casts a spell once it expires");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_GLIMMERING_BOLT_SPELL.get()), "Glimmering Bolt with Trigger", "A shiny arcane projectile that casts a spell upon collision");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.FIREBALL_SPELL.get()), "Fireball", "A fiery orb");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TIMER_FIREBALL_SPELL.get()), "Fireball with Timer", "A fiery orb that casts a spell once it expires");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_FIREBALL_SPELL.get()), "Fireball with Trigger", "A fiery orb that casts a spell upon collision");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CHAIN_SHOT_SPELL.get()), "Chain Shot", "A projectile that bounces around targets");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TIMER_CHAIN_SHOT_SPELL.get()), "Chain Shot with Timer", "A Projectile that bounces around targets and casts a spell once it expires");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_CHAIN_SHOT_SPELL.get()), "Chain Shot with Trigger", "A Projectile that bounces around targets and casts a spell upon collision");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.FREEZING_CHARGE_SPELL.get()), "Freezing Charge", "It is cold to the touch");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.IGNEOUS_CHARGE_SPELL.get()), "Igneous Charge", "It glows red hot");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.POISON_CHARGE_SPELL.get()), "Poison Charge", "Doesn't smell nice");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CRUMBLING_CHARGE_SPELL.get()), "Crumbling Charge", "Caught in a landslide...");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CRITICAL_PLUS_SPELL.get()), "Critical Plus", "Increases the chance to do critical damage");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DAMAGE_PLUS_SPELL.get()), "Damage Plus", "Increases the damage of the spells");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.LIGHT_SHOT_SPELL.get()), "Light Shot", "Increases the speed of the projectile at the cost of the damage");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.HEAVY_SHOT_SPELL.get()), "Heavy Shot", "Increases the damage of the projectile at the cost of the speed");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.ADD_MANA_SPELL.get()), "Add Mana", "Gives a mana boost to the next cast");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.ACCELERATE_SPELL.get()), "Accelerate", "Projectile spells gain a speed boost");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.INCREASE_LIFETIME_SPELL.get()), "Increase Lifetime", "Makes spells last longer");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_LIFETIME_SPELL.get()), "Decrease Lifetime", "Makes spells last less");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.INCREASE_SPREAD_SPELL.get()), "Increase Spread", "Projectile spells have more spread");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_SPREAD_SPELL.get()), "Decrease Spread", "Projectile spells have less spread");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.INCREASE_RANGE_SPELL.get()), "Increase Range", "Makes AoE spells bigger");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_RANGE_SPELL.get()), "Decrease Range", "Makes AoE spells smaller");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.FALTERING_SPELL.get()), "Faltering", "Reduces the invincibility frames (i-frames) given to the target after a hit");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.HOMING_SPELL.get()), "Homing", "Makes a projectile move towards enemies");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BOOMERANG_SPELL.get()), "Boomerang", "Makes a projectile return towards the caster");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GUIDE_SPELL.get()), "Guide", "Makes a projectile follow the caster look direction");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SMALL_DELAY_CAST_SPELL.get()), "Small Delay Cast", "Casts another spell after a little time");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.MEDIUM_DELAY_CAST_SPELL.get()), "Medium Delay Cast", "Casts another spell after some time");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BIG_DELAY_CAST_SPELL.get()), "Big Delay Cast", "Casts another spell after quite some time");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DOUBLE_CAST_SPELL.get()), "Double Cast", "Casts 2 spells at the same time");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TRIPLE_CAST_SPELL.get()), "Triple Cast", "Casts 3 spells at the same time");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DOUBLE_SPLIT_SPELL.get()), "Double Split Cast", "Casts 2 spells at the same time with different directions");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TRIPLE_SPLIT_SPELL.get()), "Triple Split Cast", "Casts 3 spells at the same time with different directions");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.QUAD_SPLIT_SPELL.get()), "Quad Split Cast", "Casts 4 spells at the same time with different directions");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.HEXAGON_CAST_SPELL.get()), "Hexagon Cast", "Casts 6 spells in a hexagon");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SPREAD_CAST_SPELL.get()), "Spread Cast", "Casts a spell in a random location within range");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.PIERCING_SPELL.get()), "Piercing", "Makes a projectile go through other entities");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BLOODLUST_SPELL.get()), "Bloodlust", "Spells gain a huge damage buff but can also hit you");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TELEPORT_SPELL.get()), "Teleport", "Teleports the caster");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SWAP_TELEPORT_SPELL.get()), "Swap", "Swaps the caster's position with another entity");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.HOME_BRINGER_TELEPORT_SPELL.get()), "Home Bringer Teleport", "Teleports a entity towards the caster");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.LONG_DISTANCE_CAST_SPELL.get()), "Long Distance Cast", "Casts a spell from further away from the caster");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.TELEPORT_CAST_SPELL.get()), "Teleport Cast", "Casts a spell from another entity position");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.LINE_CAST_SPELL.get()), "Line Cast", "Casts 5 spells in a line");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DIVIDE_BY_2_SPELL.get()), "Divide by 2", "Casts 2 copies of a spell but its damage is reduced to a half");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DIVIDE_BY_3_SPELL.get()), "Divide by 3", "Casts 3 copies of a spell but its damage is reduced to a third");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DIVIDE_BY_4_SPELL.get()), "Divide by 4", "Casts 4 copies of a spell but its damage is reduced to a forth");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_LIGHTING_BOLT_SPELL.get()), "Summon Lightning", "An electrifying experience !");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_TNT_MINECART_SPELL.get()), "Summon TNT Minecart", "Summons a minecart that can unleash a explosion");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CONJURE_BLOCK_SPELL.get()), "Conjure Block", "Summons a temporary block");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CONJURE_LIGHT_SPELL.get()), "Conjure Light", "Summons a temporary light source");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CONJURE_WEBS_SPELL.get()), "Conjure Webs", "Summons a web cocoon");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GLYPH_OF_TRIGGERING.get()), "Glyph of Triggering", "Triggers a spell once an entity steps on it, barely visible to other players");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_BEE_SWARM_SPELL.get()), "Summon Bee Swarm", "Summons 4 bees that pursue the last hit target");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_WOLF_PACK_SPELL.get()), "Summon Wolf Pack", "Summons 4 wolves that pursue the last hit target");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GUST_SPELL.get()), "Gust", "Conjures a burst of air that send entities flying");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.CHAIN_PRISON_SPELL.get()), "Chain Prison", "Locks an entity into place");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_HASTE_SPELL.get()), "Bestow Blessing: Haste", "Blesses the target with faster mining speed");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_SPEED_SPELL.get()), "Bestow Blessing: Speed", "Blesses the target with faster movement speed");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_BOOST_HEALTH_SPELL.get()), "Bestow Blessing: Boost Health", "Blesses the target with more maximum health");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_REGENERATION_SPELL.get()), "Bestow Blessing: Regeneration", "Blesses the target with health regeneration");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_RESISTANCE_SPELL.get()), "Bestow Blessing: Resistance", "Blesses the target with damage resistance");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_NIGHT_VISION_SPELL.get()), "Bestow Blessing: Night Vision", "Blesses the target with night vision");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_RESIST_FIRE_SPELL.get()), "Bestow Blessing: Fire Resistance", "Blesses the target with immunity against fire");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_SATURATION_SPELL.get()), "Bestow Blessing: Saturation", "Blesses the target with saturation");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_STRENGTH_SPELL.get()), "Bestow Blessing: Strength", "Blesses the target with strength");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_SILENCE_SPELL.get()), "Bestow Curse: Silence", "Curses the target with silence, making it unable to cast magic");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_DARKNESS_SPELL.get()), "Bestow Curse: Darkness", "Curses the target with limited vision");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_GLOW_SPELL.get()), "Bestow Curse: Glow", "Curses the target making it have a shiny aura");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_HUNGER_SPELL.get()), "Bestow Curse: Hunger", "Curses the target with hunger");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_NAUSEA_SPELL.get()), "Bestow Curse: Nausea", "Curses the target with nausea");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_LEVITATE_SPELL.get()), "Bestow Curse: Levitate", "Curses the target making it ascend to the heavens");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_MINING_FATIGUE_SPELL.get()), "Bestow Curse: Mining Fatigue", "Curses the target with reduced mining speed");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_SLOWNESS_SPELL.get()), "Bestow Curse: Slowness", "Curses the target with reduced movement speed");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_WEAKNESS_SPELL.get()), "Bestow Curse: Weakness", "Curses the target with reduced damage");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_POISON_SPELL.get()), "Bestow Curse: Poison", "Curses the target with poison");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_OF_BIG_SPELL.get()), "Bestow Curse: Big", "Curses the target and makes them big");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_OF_SMALL_SPELL.get()), "Bestow Curse: Small", "Curses the target and makes them small");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GREEK_LETTER_LAMBDA_SPELL.get()), "Lambda", "Casts a copy of the last spell in the wand");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GREEK_LETTER_DELTA_SPELL.get()), "Delta", "Casts a copy of the first spell in the wand");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.GREEK_LETTER_KAPPA_SPELL.get()), "Kappa", "Copies all the modifiers in the wand");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.HEALTH_TO_POWER_SPELL.get()), "Health to Power", "Consumes the caster's life force to make spells stronger");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.FRIENDS_TO_POWER_SPELL.get()), "Friends to Power", "Makes spells stronger the more friends you have");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.HEAVY_SPREAD_SPELL.get()), "Heavy Spread", "Increases the spread on spells, but reduces de cast and recharge times");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_RECHARGE_TIME_SPELL.get()), "Decrease Recharge Time", "Reduces the cast and recharge times");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.IGNEOUS_GAZE_SPELL.get()), "Igneous Gaze", "Spread flames and ignites entities in a cone");
        this.addSpell((SpellEffectItem)((Object)ItemRegister.FREEZING_GAZE_SPELL.get()), "Freezing Gaze", "Creates ice walls and freeze entities in a cone");
    }

    private void addSpell(SpellEffectItem item, String name, String description) {
        this.add(item, name);
        this.add(item.getDescriptionId() + ".desc", description);
    }

    private void addGlyph(Glyph glyph, String name) {
        this.add(glyph.getTexture().toLanguageKey("glyph"), name);
    }
}

