/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.datagen;

import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.registers.BlockRegister;
import com.hakimen.wandrous.common.registers.ItemRegister;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelProvider
extends net.neoforged.neoforge.client.model.generators.ItemModelProvider {
    public ItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "wandrous", existingFileHelper);
    }

    protected void registerModels() {
        this.makeItems();
        this.makeSpells();
    }

    private void makeItems() {
        this.block((Block)BlockRegister.CHERT.get());
        this.block((Block)BlockRegister.CHERT_STAIRS.get());
        this.block((Block)BlockRegister.CHERT_SLAB.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegister.CHERT_WALL.get())).toString().replaceAll("wandrous:", ""))).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/wall_inventory"), this.existingFileHelper))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/chert"));
        this.block((Block)BlockRegister.POLISHED_CHERT.get());
        this.block((Block)BlockRegister.POLISHED_CHERT_STAIRS.get());
        this.block((Block)BlockRegister.POLISHED_CHERT_SLAB.get());
        this.block((Block)BlockRegister.CHERT_BRICKS.get());
        this.block((Block)BlockRegister.CHERT_BRICKS_STAIRS.get());
        this.block((Block)BlockRegister.CHERT_BRICKS_SLAB.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegister.CHERT_BRICKS_WALL.get())).toString().replaceAll("wandrous:", ""))).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/wall_inventory"), this.existingFileHelper))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/chert_bricks"));
        this.block((Block)BlockRegister.CRACKED_CHERT_BRICKS.get());
        this.blockWithAnotherModel((Block)BlockRegister.CHISELED_CHERT_BRICKS.get(), ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/chiseled_chert_bricks_0"));
        this.block((Block)BlockRegister.CHERT_PILLAR.get());
        this.block((Block)BlockRegister.MOSSY_CHERT_BRICKS.get());
        this.block((Block)BlockRegister.MOSSY_CHERT_BRICKS_STAIRS.get());
        this.block((Block)BlockRegister.MOSSY_CHERT_BRICKS_SLAB.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegister.MOSSY_CHERT_BRICKS_WALL.get())).toString().replaceAll("wandrous:", ""))).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/wall_inventory"), this.existingFileHelper))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/mossy_chert_bricks"));
        this.block((Block)BlockRegister.CHERT_TILES.get());
        this.block((Block)BlockRegister.CHERT_TILES_STAIRS.get());
        this.block((Block)BlockRegister.CHERT_TILES_SLAB.get());
        this.block((Block)BlockRegister.MOSSY_CHERT_TILES.get());
        this.block((Block)BlockRegister.MOSSY_CHERT_TILES_STAIRS.get());
        this.block((Block)BlockRegister.MOSSY_CHERT_TILES_SLAB.get());
        this.block((Block)BlockRegister.TEALESTITE_BLOCK.get());
        this.block((Block)BlockRegister.BUDDING_TEALESTITE.get());
        this.block((Block)BlockRegister.GLYPH_PROJECTOR.get());
        this.block((Block)BlockRegister.ARCANE_INSCRIBER.get());
        this.singleTexture("small_tealestite_bud", this.mcLoc("generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/small_tealestite_bud"));
        this.singleTexture("medium_tealestite_bud", this.mcLoc("generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/medium_tealestite_bud"));
        this.singleTexture("big_tealestite_bud", this.mcLoc("generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/big_tealestite_bud"));
        this.singleTexture("tealestite_cluster", this.mcLoc("generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"block/tealestite_cluster"));
        this.basicItem((Item)ItemRegister.SCROLL.get());
        this.basicItem((Item)ItemRegister.TEALESTITE_SHARD.get());
        this.basicItem((Item)ItemRegister.TEALESTITE_RECHARGE_CRYSTAL.get());
        this.basicItem((Item)ItemRegister.TEALESTITE_GREATER_RECHARGE_CRYSTAL.get());
        this.basicItem((Item)ItemRegister.INSCRIBED_LENS.get());
    }

    private void makeSpells() {
        this.makeTriggerSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_FIREBALL_SPELL.get()), "minecraft:item/fire_charge");
        this.makeTimerSpell((SpellEffectItem)((Object)ItemRegister.TIMER_FIREBALL_SPELL.get()), "minecraft:item/fire_charge");
        this.makeVanillaBasedSpell((SpellEffectItem)((Object)ItemRegister.FIREBALL_SPELL.get()), "minecraft:item/fire_charge");
        this.makeTriggerSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_GLIMMERING_BOLT_SPELL.get()), "wandrous:item/spell/glimmering_bolt");
        this.makeTimerSpell((SpellEffectItem)((Object)ItemRegister.TIMER_GLIMMERING_BOLT_SPELL.get()), "wandrous:item/spell/glimmering_bolt");
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.GLIMMERING_BOLT_SPELL.get()));
        this.makeTriggerSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_SONIC_BOOM_SPELL.get()), "wandrous:item/spell/sonic_boom");
        this.makeTimerSpell((SpellEffectItem)((Object)ItemRegister.TIMER_SONIC_BOOM_SPELL.get()), "wandrous:item/spell/sonic_boom");
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SONIC_BOOM_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BLACK_HOLE_SPELL.get()));
        this.makeTimerSpell((SpellEffectItem)((Object)ItemRegister.TIMER_BLACK_HOLE_SPELL.get()), "wandrous:item/spell/black_hole");
        this.makeTriggerSpell((SpellEffectItem)((Object)ItemRegister.TRIGGER_CHAIN_SHOT_SPELL.get()), "wandrous:item/spell/chain_shot");
        this.makeTimerSpell((SpellEffectItem)((Object)ItemRegister.TIMER_CHAIN_SHOT_SPELL.get()), "wandrous:item/spell/chain_shot");
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.CHAIN_SHOT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BOMB_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DIVIDE_BY_2_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DIVIDE_BY_3_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DIVIDE_BY_4_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DOUBLE_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.TRIPLE_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.TELEPORT_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.LONG_DISTANCE_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.LINE_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DOUBLE_SPLIT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.TRIPLE_SPLIT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.QUAD_SPLIT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.HEXAGON_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SPREAD_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.FREEZING_CHARGE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.POISON_CHARGE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.IGNEOUS_CHARGE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.CRUMBLING_CHARGE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.ACCELERATE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.CRITICAL_PLUS_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.ADD_MANA_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DAMAGE_PLUS_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.HEAVY_SHOT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.LIGHT_SHOT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.INCREASE_LIFETIME_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_LIFETIME_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.INCREASE_RANGE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_RANGE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.INCREASE_SPREAD_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_SPREAD_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.HEAVY_SPREAD_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DECREASE_RECHARGE_TIME_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.PIERCING_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BLOODLUST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.FALTERING_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.HEALTH_TO_POWER_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.FRIENDS_TO_POWER_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_LIGHTING_BOLT_SPELL.get()));
        this.makeVanillaBasedSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_TNT_MINECART_SPELL.get()), "minecraft:item/tnt_minecart");
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_BEE_SWARM_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SUMMON_WOLF_PACK_SPELL.get()));
        this.makeTriggerSpell((SpellEffectItem)((Object)ItemRegister.GLYPH_OF_TRIGGERING.get()), "wandrous:item/spell/glyph_of_triggering");
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.CHAINSAW_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.DRILL_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.GIGA_DRILL_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.TELEPORT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SWAP_TELEPORT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.HOME_BRINGER_TELEPORT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.COLLECT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SMELT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.SMALL_DELAY_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.MEDIUM_DELAY_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BIG_DELAY_CAST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.EXPLOSION_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.MAJOR_EXPLOSION_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.NUKE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.PLASMA_BEAM.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.HOMING_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BOOMERANG_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.GUIDE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.CONJURE_LIGHT_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.CONJURE_BLOCK_SPELL.get()));
        this.makeVanillaBasedSpell((SpellEffectItem)((Object)ItemRegister.CONJURE_WEBS_SPELL.get()), "minecraft:block/cobweb");
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.GUST_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.CHAIN_PRISON_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_SILENCE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_HUNGER_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_MINING_FATIGUE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_LEVITATE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_GLOW_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_DARKNESS_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_WEAKNESS_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_NAUSEA_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_SLOWNESS_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_OF_BIG_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_OF_SMALL_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_CURSE_POISON_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_HASTE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_BOOST_HEALTH_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_REGENERATION_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_RESISTANCE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_SATURATION_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_NIGHT_VISION_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_RESIST_FIRE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_SPEED_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.BESTOW_BLESSING_STRENGTH_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.IGNEOUS_GAZE_SPELL.get()));
        this.makeSpell((SpellEffectItem)((Object)ItemRegister.FREEZING_GAZE_SPELL.get()));
        this.makeSpellWithSpellFrame((SpellEffectItem)((Object)ItemRegister.GREEK_LETTER_DELTA_SPELL.get()));
        this.makeSpellWithSpellFrame((SpellEffectItem)((Object)ItemRegister.GREEK_LETTER_LAMBDA_SPELL.get()));
        this.makeSpellWithSpellFrame((SpellEffectItem)((Object)ItemRegister.GREEK_LETTER_KAPPA_SPELL.get()));
    }

    private ItemModelBuilder block(Block block) {
        return (ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block).toString().replaceAll("wandrous:", ""), ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).toString().replaceAll("wandrous:", ""))));
    }

    private ItemModelBuilder blockWithAnotherModel(Block block, ResourceLocation location) {
        return (ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block).toString().replaceAll("wandrous:", ""), location);
    }

    public void makeTriggerSpell(SpellEffectItem item, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.parse((String)"minecraft:item/generated"), this.existingFileHelper))).texture("layer0", "wandrous:item/spell/bases/spell_base")).texture("layer1", texture)).texture("layer2", "wandrous:item/spell/layers/trigger");
    }

    public void makeTriggerSpell(SpellEffectItem item) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.parse((String)"minecraft:item/generated"), this.existingFileHelper))).texture("layer0", "wandrous:item/spell/bases/spell_base")).texture("layer1", item.toString().replace(":", ":item/spell/"))).texture("layer2", "wandrous:item/spell/layers/trigger");
    }

    public void makeTimerSpell(SpellEffectItem item, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.parse((String)"minecraft:item/generated"), this.existingFileHelper))).texture("layer0", "wandrous:item/spell/bases/spell_base")).texture("layer1", texture)).texture("layer2", "wandrous:item/spell/layers/timer");
    }

    public void makeVanillaBasedSpell(SpellEffectItem item, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.parse((String)"minecraft:item/generated"), this.existingFileHelper))).texture("layer0", item.getSpellEffect().hasKind(8) ? "wandrous:item/spell/bases/spell_base" : "wandrous:item/spell/bases/modifier_base")).texture("layer1", texture);
    }

    public void makeSpell(SpellEffectItem item) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.parse((String)"minecraft:item/generated"), this.existingFileHelper))).texture("layer0", item.getSpellEffect().hasKind(8) ? "wandrous:item/spell/bases/spell_base" : "wandrous:item/spell/bases/modifier_base")).texture("layer1", item.toString().replace(":", ":item/spell/"));
    }

    public void makeSpellWithSpellFrame(SpellEffectItem item) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.parse((String)"minecraft:item/generated"), this.existingFileHelper))).texture("layer0", "wandrous:item/spell/bases/spell_base")).texture("layer1", item.toString().replace(":", ":item/spell/"));
    }

    public void makeSpellWithModifierFrame(SpellEffectItem item) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.parse((String)"minecraft:item/generated"), this.existingFileHelper))).texture("layer0", "wandrous:item/spell/bases/modifier_base")).texture("layer1", item.toString().replace(":", ":item/spell/"));
    }
}

