/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.datagen;

import com.hakimen.wandrous.common.datagen.BlockModelProvider;
import com.hakimen.wandrous.common.datagen.BlockStateProvider;
import com.hakimen.wandrous.common.datagen.BlockTagProvider;
import com.hakimen.wandrous.common.datagen.GlobalLootModProvider;
import com.hakimen.wandrous.common.datagen.ItemModelProvider;
import com.hakimen.wandrous.common.datagen.LangProvider;
import com.hakimen.wandrous.common.datagen.LootProvider;
import com.hakimen.wandrous.common.datagen.RecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="wandrous", bus=EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        gen.addProvider(true, packOutput -> new BlockTagProvider(packOutput, event.getLookupProvider(), existingFileHelper));
        gen.addProvider(true, packOutput -> new BlockModelProvider(packOutput, existingFileHelper));
        gen.addProvider(true, packOutput -> new BlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(true, packOutput -> new ItemModelProvider(packOutput, existingFileHelper));
        gen.addProvider(true, pOutput -> LootProvider.create(pOutput, provider));
        gen.addProvider(true, pOutput -> new GlobalLootModProvider(pOutput, provider));
        gen.addProvider(true, LangProvider::new);
        gen.addProvider(true, pOutput -> new RecipeProvider(pOutput, provider));
    }
}

