/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.data;

import com.google.gson.Gson;
import com.hakimen.wandrous.Wandrous;
import com.hakimen.wandrous.common.data.Scroll;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class ScrollDataListener {
    static List<Scroll> allScrolls = new ArrayList<Scroll>();

    public static List<Scroll> getAllScrolls() {
        return allScrolls;
    }

    public static void clearCache() {
        allScrolls.clear();
    }

    public static CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller1, Executor executor, Executor executor1) {
        ScrollDataListener.clearCache();
        Gson gson = new Gson();
        long start = System.currentTimeMillis();
        resourceManager.listResources("scroll", location -> location.getPath().endsWith(".json")).forEach((location, resource) -> {
            try {
                Scroll scroll = (Scroll)gson.fromJson((Reader)resource.openAsReader(), Scroll.class);
                allScrolls.add(scroll);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        long end = System.currentTimeMillis() - start;
        Wandrous.LOGGER.info("Finished parsing scrolls, took %sms, total scrolls %s".formatted(end, allScrolls.size()));
        return preparationBarrier.wait(null);
    }
}

