/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.block_entity;

import com.hakimen.wandrous.common.registers.BlockEntityRegister;
import com.hakimen.wandrous.common.utils.GlyphUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class GlyphProjectorBlockEntity
extends BlockEntity {
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return GlyphUtils.hasGlyph(stack);
        }

        protected void onContentsChanged(int slot) {
            GlyphProjectorBlockEntity.this.setChanged();
            GlyphProjectorBlockEntity.this.level.sendBlockUpdated(GlyphProjectorBlockEntity.this.getBlockPos(), GlyphProjectorBlockEntity.this.getBlockState(), GlyphProjectorBlockEntity.this.getBlockState(), 3);
        }
    };

    public GlyphProjectorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegister.GLYPH_PROJECTOR_ENTITY.get(), pPos, pBlockState);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.inventory.deserializeNBT(pRegistries, pTag.getCompound("Inventory"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::saveWithFullMetadata);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithFullMetadata(pRegistries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
        this.level.setBlockAndUpdate(this.getBlockPos(), this.getBlockState());
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("Inventory", (Tag)this.inventory.serializeNBT(pRegistries));
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public void setChanged() {
        super.setChanged();
    }
}

