/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.block_entity;

import com.hakimen.wandrous.common.block.ConjuredLightBlock;
import com.hakimen.wandrous.common.registers.BlockEntityRegister;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ConjuredBlockEntity
extends BlockEntity
implements BlockEntityTicker<ConjuredBlockEntity> {
    int lifeTime;
    int tick;

    public ConjuredBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegister.CONJURED_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.putInt("LifeTime", this.lifeTime);
        pTag.putInt("Tick", this.tick);
        super.saveAdditional(pTag, registries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.tick = pTag.getInt("Tick");
        this.lifeTime = pTag.getInt("LifeTime");
        super.loadAdditional(pTag, pRegistries);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, ConjuredBlockEntity conjuredLightBlockEntity) {
        if (level.isClientSide()) {
            Random r = new Random();
            if ((double)r.nextFloat(0.0f, 1.0f) < 0.05) {
                if (blockState.getBlock() instanceof ConjuredLightBlock) {
                    level.addParticle((ParticleOptions)ParticleTypes.END_ROD, (double)blockPos.getX() + 0.5 + (double)r.nextFloat(-0.2f, 0.2f), (double)blockPos.getY() + 0.5 + (double)r.nextFloat(-0.2f, 0.2f), (double)blockPos.getZ() + 0.5 + (double)r.nextFloat(-0.2f, 0.2f), 0.0, 0.0, 0.0);
                } else {
                    level.addParticle((ParticleOptions)ParticleTypes.END_ROD, (double)blockPos.getX() + 0.5 + (double)r.nextFloat(-0.6f, 0.6f), (double)blockPos.getY() + 0.5 + (double)r.nextFloat(-0.6f, 0.6f), (double)blockPos.getZ() + 0.5 + (double)r.nextFloat(-0.6f, 0.6f), 0.0, 0.0, 0.0);
                }
            }
        } else {
            ++this.tick;
            if (this.tick >= this.lifeTime) {
                BlockState self = level.getBlockState(blockPos);
                SoundType sound = self.getSoundType();
                level.playLocalSound(blockPos, sound.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public ConjuredBlockEntity setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
        return this;
    }
}

