/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.block_entity;

import com.hakimen.wandrous.common.recipe.ArcaneInscriberRecipeInput;
import com.hakimen.wandrous.common.recipe.ArcaneInscribingRecipe;
import com.hakimen.wandrous.common.registers.BlockEntityRegister;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ArcaneInscriberBlockEntity
extends BlockEntity
implements BlockEntityTicker<ArcaneInscriberBlockEntity> {
    List<BlockPos> offsets = List.of(new BlockPos(0, -1, -3), new BlockPos(-3, -1, 0), new BlockPos(3, -1, 0), new BlockPos(0, -1, 3), new BlockPos(-2, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(0, -1, -6), new BlockPos(-6, -1, 0), new BlockPos(6, -1, 0), new BlockPos(0, -1, 6), new BlockPos(-4, -1, -4), new BlockPos(-4, -1, 4), new BlockPos(4, -1, 4), new BlockPos(4, -1, -4));
    ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ArcaneInscriberBlockEntity.this.setChanged();
            ArcaneInscriberBlockEntity.this.level.sendBlockUpdated(ArcaneInscriberBlockEntity.this.getBlockPos(), ArcaneInscriberBlockEntity.this.getBlockState(), ArcaneInscriberBlockEntity.this.getBlockState(), 3);
        }
    };
    int progress = 0;
    int maxTicks = 0;

    public ArcaneInscriberBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegister.ARCANE_INSCRIBER.get(), pPos, pBlockState);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.inventory.deserializeNBT(pRegistries, pTag.getCompound("Inventory"));
        this.progress = pTag.getInt("Progress");
        this.maxTicks = pTag.getInt("MaxTicks");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::saveWithFullMetadata);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithFullMetadata(pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("Inventory", (Tag)this.inventory.serializeNBT(pRegistries));
        pTag.putInt("Progress", this.progress);
        pTag.putInt("MaxTicks", this.maxTicks);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public void clientTick(Level pLevel, BlockPos pPos, BlockState pState, ArcaneInscriberBlockEntity pBlockEntity) {
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState, ArcaneInscriberBlockEntity pBlockEntity) {
        AtomicInteger totalCount = new AtomicInteger();
        SimpleContainer simpleContainer = new SimpleContainer(16);
        for (BlockPos offset : this.offsets) {
            BlockPos pos = pPos.offset((Vec3i)offset);
            pLevel.getBlockEntity(pos, (BlockEntityType)BlockEntityRegister.GLYPH_PROJECTOR_ENTITY.get()).ifPresent(glyphProjectorBlockEntity -> {
                totalCount.getAndIncrement();
                simpleContainer.addItem(glyphProjectorBlockEntity.getInventory().getStackInSlot(0));
            });
        }
        int calculatedTier = totalCount.get() / 4;
        ArcaneInscriberRecipeInput input = new ArcaneInscriberRecipeInput(simpleContainer, calculatedTier, this.getInventory().getStackInSlot(0));
        Optional match = pLevel.getRecipeManager().getRecipeFor((RecipeType)ArcaneInscribingRecipe.Type.INSTANCE, (RecipeInput)input, pLevel);
        if (this.isCrafting() && pBlockEntity.getProgress() <= 1) {
            pLevel.playSound(null, pPos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (match.isPresent()) {
            ArcaneInscribingRecipe recipe = (ArcaneInscribingRecipe)((RecipeHolder)match.get()).value();
            if (this.maxTicks != recipe.getTicksNeeded()) {
                this.maxTicks = recipe.getTicksNeeded();
            }
            if (this.progress < recipe.getTicksNeeded()) {
                ++this.progress;
                this.setChanged();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            if (this.progress == recipe.getTicksNeeded()) {
                this.getInventory().extractItem(0, 1, false);
                ItemStack returnFromCraft = ((ArcaneInscribingRecipe)((RecipeHolder)match.get()).value()).assemble(input, (HolderLookup.Provider)pLevel.registryAccess());
                for (BlockPos offset : this.offsets) {
                    BlockPos pos = pPos.offset((Vec3i)offset);
                    pLevel.getBlockEntity(pos, (BlockEntityType)BlockEntityRegister.GLYPH_PROJECTOR_ENTITY.get()).ifPresent(glyphProjectorBlockEntity -> {
                        ItemStack stackInSlot = glyphProjectorBlockEntity.getInventory().getStackInSlot(0);
                        if (stackInSlot.isDamageableItem() && stackInSlot.getDamageValue() != stackInSlot.getMaxDamage()) {
                            stackInSlot.setDamageValue(stackInSlot.getDamageValue() + 1);
                        } else if (stackInSlot.getDamageValue() >= stackInSlot.getMaxDamage() - 1) {
                            glyphProjectorBlockEntity.getInventory().extractItem(0, 1, false);
                            glyphProjectorBlockEntity.setChanged();
                        }
                    });
                }
                this.getInventory().insertItem(0, returnFromCraft, false);
                this.progress = 0;
                this.setChanged();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        } else if (this.progress > 0) {
            this.progress = Math.max(this.progress - 1, 0);
            this.maxTicks = 0;
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public Integer getProgress() {
        return this.progress;
    }

    public boolean isCrafting() {
        return this.progress > 0;
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.setBlockAndUpdate(this.getBlockPos(), this.getBlockState());
        }
    }

    public List<BlockPos> getOffsets() {
        return this.offsets;
    }
}

