/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.block;

import com.hakimen.wandrous.common.registers.BlockRegister;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class BuddingTealestiteBlock
extends BuddingAmethystBlock {
    private static final Direction[] DIRECTIONS = Direction.values();

    public BuddingTealestiteBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[pRandom.nextInt(DIRECTIONS.length)];
            BlockPos blockpos = pPos.relative(direction);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            Block block = null;
            if (BuddingTealestiteBlock.canClusterGrowAtState(blockstate)) {
                block = (Block)BlockRegister.SMALL_TEALESTITE_BUD.get();
            } else if (blockstate.is((Block)BlockRegister.SMALL_TEALESTITE_BUD.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)BlockRegister.MEDIUM_TEALESTITE_BUD.get();
            } else if (blockstate.is((Block)BlockRegister.MEDIUM_TEALESTITE_BUD.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)BlockRegister.BIG_TEALESTITE_BUD.get();
            } else if (blockstate.is((Block)BlockRegister.BIG_TEALESTITE_BUD.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)BlockRegister.TEALESTITE_CLUSTER.get();
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.getFluidState().getType() == Fluids.WATER));
                pLevel.setBlockAndUpdate(blockpos, blockstate1);
            }
        }
    }

    public static boolean canClusterGrowAtState(BlockState pState) {
        return pState.isAir() || pState.is(Blocks.WATER) && pState.getFluidState().getAmount() == 8;
    }
}

