/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.common.block;

import com.hakimen.wandrous.common.block_entity.ArcaneInscriberBlockEntity;
import com.hakimen.wandrous.common.registers.BlockEntityRegister;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ArcaneInscriberBlock
extends Block
implements EntityBlock {
    public ArcaneInscriberBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ArcaneInscriberBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        Optional blockEntity = pLevel.getBlockEntity(pPos, (BlockEntityType)BlockEntityRegister.ARCANE_INSCRIBER.get());
        if (blockEntity.isPresent()) {
            ArcaneInscriberBlockEntity arcaneInscriberBlockEntity = (ArcaneInscriberBlockEntity)((Object)blockEntity.get());
            ItemStack currentItem = arcaneInscriberBlockEntity.getInventory().getStackInSlot(0);
            if (arcaneInscriberBlockEntity.getInventory().isItemValid(0, pStack)) {
                if (!currentItem.isEmpty() && pStack.isEmpty()) {
                    arcaneInscriberBlockEntity.getInventory().insertItem(0, pStack.copy(), false);
                    pStack.shrink(1);
                    if (!pPlayer.addItem(currentItem)) {
                        pLevel.addFreshEntity((Entity)new ItemEntity(pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), currentItem));
                    }
                    pLevel.playSound(pPlayer, pPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.8f + pLevel.getRandom().nextFloat() / 4.0f);
                    arcaneInscriberBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                if (!pStack.isEmpty()) {
                    ItemStack extracted = arcaneInscriberBlockEntity.getInventory().extractItem(0, 1, false);
                    arcaneInscriberBlockEntity.getInventory().insertItem(0, pStack.copyWithCount(1), false);
                    pStack.shrink(1);
                    if (!pPlayer.addItem(extracted)) {
                        pLevel.addFreshEntity((Entity)new ItemEntity(pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), extracted));
                    }
                    pLevel.playSound(pPlayer, pPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.8f + pLevel.getRandom().nextFloat() / 4.0f);
                    arcaneInscriberBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        if (pStack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.FAIL;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        ArcaneInscriberBlockEntity arcaneInscriberBlockEntity;
        ItemStack currentItem;
        Optional blockEntity = pLevel.getBlockEntity(pPos, (BlockEntityType)BlockEntityRegister.ARCANE_INSCRIBER.get());
        if (blockEntity.isPresent() && !(currentItem = (arcaneInscriberBlockEntity = (ArcaneInscriberBlockEntity)((Object)blockEntity.get())).getInventory().getStackInSlot(0)).isEmpty()) {
            ItemStack extracted = arcaneInscriberBlockEntity.getInventory().extractItem(0, 1, false);
            if (!pPlayer.addItem(extracted)) {
                pLevel.addFreshEntity((Entity)new ItemEntity(pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), extracted));
            }
            pLevel.playSound(pPlayer, pPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.8f + pLevel.getRandom().nextFloat() / 4.0f);
            arcaneInscriberBlockEntity.setChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        Optional blockEntity = pLevel.getBlockEntity(pPos, (BlockEntityType)BlockEntityRegister.ARCANE_INSCRIBER.get());
        if (blockEntity.isPresent()) {
            ArcaneInscriberBlockEntity arcaneInscriberBlockEntity = (ArcaneInscriberBlockEntity)((Object)blockEntity.get());
            ArcaneInscriberBlock.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)arcaneInscriberBlockEntity.getInventory().getStackInSlot(0));
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ArcaneInscriberBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? (pLevel1, pPos, pState1, pBlockEntity) -> {
            BlockEntity be = pBlockEntityType.getBlockEntity((BlockGetter)pLevel1, pPos);
            if (be instanceof ArcaneInscriberBlockEntity) {
                ArcaneInscriberBlockEntity arcaneInscriberBlockEntity = (ArcaneInscriberBlockEntity)be;
                arcaneInscriberBlockEntity.clientTick(pLevel, pPos, pState, arcaneInscriberBlockEntity);
            }
        } : (pLevel1, pPos, pState1, pBlockEntity) -> {
            BlockEntity be = pBlockEntityType.getBlockEntity((BlockGetter)pLevel1, pPos);
            if (be instanceof ArcaneInscriberBlockEntity) {
                ArcaneInscriberBlockEntity arcaneInscriberBlockEntity = (ArcaneInscriberBlockEntity)be;
                arcaneInscriberBlockEntity.tick(pLevel, pPos, pState, arcaneInscriberBlockEntity);
            }
        };
    }
}

