/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.tooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class SpellTooltipRenderer
implements ClientTooltipComponent {
    private final SpellTooltipComponent comp;

    public SpellTooltipRenderer(SpellTooltipComponent comp) {
        this.comp = comp;
    }

    public int getHeight() {
        return 22;
    }

    public int getWidth(Font font) {
        return this.comp.spells.size() * 18 + (this.comp.overflow ? 8 + font.width(". . .") : 0);
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics gfx) {
        for (ItemStack spellItem : this.comp.spells()) {
            if (spellItem.isEmpty()) continue;
            PoseStack pose = gfx.pose();
            pose.pushPose();
            pose.scale(1.0f, 1.0f, 1.0f);
            gfx.renderFakeItem(spellItem, pX + 18 * this.comp.spells().indexOf(spellItem) + 1, pY + 3);
            pose.popPose();
        }
    }

    public void renderText(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
        if (this.comp.overflow()) {
            pFont.drawInBatch(Component.literal((String)". . .").getString(), (float)(4 + pMouseX + 18 * this.comp.spells().size() + 1), (float)(pMouseY + 10), 0xAABBCC, true, pMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public record SpellTooltipComponent(List<ItemStack> spells, boolean overflow) implements TooltipComponent
    {
    }
}

