/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.tooltip;

import com.hakimen.wandrous.client.utils.RenderUtils;
import com.hakimen.wandrous.common.item.component.WandDataComponent;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class SpellStatsTooltipRenderer
implements ClientTooltipComponent {
    final SpellStatsComponent stats;

    public SpellStatsTooltipRenderer(SpellStatsComponent stats) {
        this.stats = stats;
    }

    public int getHeight() {
        return 74;
    }

    public int getWidth(Font pFont) {
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)this.stats.wand().get(DataComponentsRegister.WAND_COMPONENT);
        return pFont.width(I18n.get((String)"tooltip.wandrous.wand.mana_charge_speed", (Object[])new Object[]{stat.getManaChargeSpeed()})) + 16;
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics gfx) {
        int i;
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/gui/tooltip/status.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.setShader(GameRenderer::getRendertypeEntityTranslucentShader);
        VertexConsumer consumer = gfx.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)location));
        Matrix4f mat = gfx.pose().last().pose();
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)this.stats.wand().get(DataComponentsRegister.WAND_COMPONENT);
        List<String> keys = List.of(I18n.get((String)"tooltip.wandrous.wand.cast_delay", (Object[])new Object[]{"%.2f".formatted(Float.valueOf(stat.getCastDelay()))}), I18n.get((String)"tooltip.wandrous.wand.recharge_time", (Object[])new Object[]{"%.2f".formatted(Float.valueOf(stat.getRechargeSpeed()))}), I18n.get((String)"tooltip.wandrous.wand.mana_max", (Object[])new Object[]{stat.getMaxMana()}), I18n.get((String)"tooltip.wandrous.wand.current_mana", (Object[])new Object[]{stat.getMana()}), I18n.get((String)"tooltip.wandrous.wand.mana_charge_speed", (Object[])new Object[]{stat.getManaChargeSpeed()}), I18n.get((String)"tooltip.wandrous.wand.capacatiy", (Object[])new Object[]{stat.getCapacity()}));
        for (i = 0; i < 6; ++i) {
            RenderUtils.guiQuad(consumer, mat, gfx.pose().last(), new Vector3f((float)pX, (float)(pY + 12 * i), 0.0f), new Vector3f(12.0f, 12.0f, 0.0f), new Vector2f(0.16666667f * (float)i, 0.0f), new Vector2f(0.16666667f, 1.0f), 0xF000E0, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        }
        for (i = 0; i < 6; ++i) {
            gfx.drawString(pFont, keys.get(i), pX + 16, pY + 12 * i + 3, 0xFFFFFF);
        }
    }

    public void renderText(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
        super.renderText(pFont, pMouseX, pMouseY, pMatrix, pBufferSource);
    }

    public record SpellStatsComponent(ItemStack wand) implements TooltipComponent
    {
    }
}

