/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.tooltip;

import com.hakimen.wandrous.client.utils.RenderUtils;
import com.hakimen.wandrous.common.data.Glyph;
import com.hakimen.wandrous.common.utils.GlyphUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class GlyphTooltipRenderer
implements ClientTooltipComponent {
    private final GlyphTooltipComponent comp;

    public GlyphTooltipRenderer(GlyphTooltipComponent comp) {
        this.comp = comp;
    }

    public int getHeight() {
        return 20;
    }

    public int getWidth(Font font) {
        return 16;
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics gfx) {
        ResourceLocation location = GlyphUtils.getGlyphTextureFromResourceLocation(this.comp.glyph().getId());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.setShader(GameRenderer::getRendertypeEntityTranslucentShader);
        VertexConsumer consumer = gfx.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)location));
        Matrix4f mat = gfx.pose().last().pose();
        RenderUtils.guiQuad(consumer, mat, gfx.pose().last(), new Vector3f((float)pX, (float)pY, 0.0f), new Vector3f(14.0f, 16.0f, 0.0f), new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0xF000E0, this.comp.glyph.getColor());
    }

    public void renderText(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
    }

    public record GlyphTooltipComponent(Glyph glyph) implements TooltipComponent
    {
    }
}

