/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.menus;

import com.hakimen.wandrous.common.item.WandItem;
import com.hakimen.wandrous.common.item.component.WandDataComponent;
import com.hakimen.wandrous.common.registers.ContainerRegister;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class WandTinkerMenu
extends AbstractContainerMenu {
    ItemStack wand;
    IItemHandler playerInventory;

    public ItemStack getWand() {
        return this.wand;
    }

    public WandTinkerMenu(int pContainerId, Inventory pInventory, final Player pPlayer, ItemStack stack) {
        super((MenuType)ContainerRegister.WAND_TINKER_MENU.get(), pContainerId);
        this.playerInventory = new InvWrapper((Container)pInventory);
        this.wand = stack.getItem() instanceof WandItem ? stack : pPlayer.getOffhandItem();
        Optional<ItemStackHandler> caps = Optional.ofNullable((ItemStackHandler)this.wand.getCapability(Capabilities.ItemHandler.ITEM));
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get());
        caps.ifPresent(itemStackHandler -> {
            if (!pPlayer.level().isClientSide) {
                itemStackHandler.deserializeNBT((HolderLookup.Provider)pPlayer.level().registryAccess(), stat.getInventory());
            }
        });
        caps.ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, i, 8 + 18 * (i % 9), 18 + 18 * (i / 9), (ItemStackHandler)handler){
                    final /* synthetic */ ItemStackHandler val$handler;
                    {
                        this.val$handler = itemStackHandler;
                        super(arg0, arg1, arg2, arg3);
                    }

                    public void setChanged() {
                        ItemStack stack = WandTinkerMenu.this.wand;
                        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get());
                        WandDataComponent.WandStatBuilder builder = new WandDataComponent.WandStatBuilder(stat);
                        if (!pPlayer.isLocalPlayer() && !pPlayer.level().isClientSide) {
                            builder.setInventory(this.val$handler.serializeNBT((HolderLookup.Provider)pPlayer.registryAccess()));
                            stack.set((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)builder.build());
                        }
                    }
                });
            }
        });
        this.layoutPlayerInventorySlots(8, 148, caps, pPlayer);
    }

    private int addSlotRange(final IItemHandler handler, int index, int x, int y, int amount, int dx, final Optional<ItemStackHandler> caps, final Player pPlayer) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y){

                public boolean mayPickup(Player playerIn) {
                    return !handler.getStackInSlot(this.getSlotIndex()).equals(playerIn.getItemInHand(playerIn.getUsedItemHand())) && super.mayPickup(playerIn);
                }

                public void setChanged() {
                    caps.ifPresent(itemStackHandler -> {
                        ItemStack stack = WandTinkerMenu.this.wand;
                        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get());
                        WandDataComponent.WandStatBuilder builder = new WandDataComponent.WandStatBuilder(stat);
                        if (!pPlayer2.level().isClientSide) {
                            builder.setInventory(itemStackHandler.serializeNBT((HolderLookup.Provider)pPlayer.level().registryAccess()));
                            stack.set((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get(), (Object)builder.build());
                            super.setChanged();
                        }
                    });
                }
            });
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy, Optional<ItemStackHandler> caps, Player player) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx, caps, player);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow, Optional<ItemStackHandler> caps, Player player) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18, caps, player);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18, caps, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        WandDataComponent.WandStat stat = (WandDataComponent.WandStat)this.wand.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get());
        int capacity = stat.getCapacity();
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < capacity ? !this.moveItemStackTo(itemstack1, capacity, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, capacity, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return player.isAlive();
    }
}

