/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.event;

import com.hakimen.wandrous.client.tooltip.GlyphTooltipRenderer;
import com.hakimen.wandrous.client.tooltip.SpellStatsTooltipRenderer;
import com.hakimen.wandrous.client.tooltip.SpellTooltipRenderer;
import com.hakimen.wandrous.common.data.Glyph;
import com.hakimen.wandrous.common.item.InscribedLensItem;
import com.hakimen.wandrous.common.item.ScrollItem;
import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.item.WandItem;
import com.hakimen.wandrous.common.item.component.InscribedLensDataComponent;
import com.hakimen.wandrous.common.item.component.ScrollDataComponent;
import com.hakimen.wandrous.common.item.component.WandDataComponent;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.hakimen.wandrous.common.registers.GlyphRegister;
import com.hakimen.wandrous.common.registers.ItemRegister;
import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@EventBusSubscriber(modid="wandrous", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class RenderToolTips {
    @SubscribeEvent
    public static void renderTooltips(RenderTooltipEvent.GatherComponents e) {
        ItemStack stack = e.getItemStack();
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WandItem.class, ScrollItem.class, InscribedLensItem.class}, (Object)item2, n)) {
            case 0: {
                WandItem wandItem = (WandItem)item2;
                RenderToolTips.renderForWand(e, stack);
                break;
            }
            case 1: {
                ScrollItem scrollItem = (ScrollItem)item2;
                RenderToolTips.renderForScroll(e, stack);
                break;
            }
            case 2: {
                InscribedLensItem inscribedLensItem = (InscribedLensItem)item2;
                RenderToolTips.renderForLens(e, stack);
                break;
            }
        }
    }

    private static void renderForLens(RenderTooltipEvent.GatherComponents e, ItemStack stack) {
        Optional.ofNullable((InscribedLensDataComponent.GlyphData)stack.get((DataComponentType)DataComponentsRegister.GLYPH_COMPONENT.get())).ifPresent(glyphData -> {
            Glyph glyph = (Glyph)((Registry)GlyphRegister.GLYPHS.getRegistry().get()).get(glyphData.getId());
            List list = e.getTooltipElements();
            int rmvIdx = -1;
            for (int i = 0; i < list.size(); ++i) {
                PlainTextContents.LiteralContents tc;
                Component comp;
                ComponentContents patt1$temp;
                Object patt0$temp;
                Optional o = ((Either)list.get(i)).left();
                if (!o.isPresent() || !((patt0$temp = o.get()) instanceof Component) || !((patt1$temp = (comp = (Component)patt0$temp).getContents()) instanceof PlainTextContents.LiteralContents) || !"GLYPH_MARKER".equals((tc = (PlainTextContents.LiteralContents)patt1$temp).text())) continue;
                rmvIdx = i;
                list.remove(i);
                break;
            }
            if (rmvIdx == -1) {
                return;
            }
            e.getTooltipElements().add(rmvIdx, Either.right((Object)new GlyphTooltipRenderer.GlyphTooltipComponent(glyph)));
        });
    }

    private static void renderForWand(RenderTooltipEvent.GatherComponents e, ItemStack stack) {
        int wandCapacity = ((WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getCapacity();
        if (wandCapacity == 0) {
            return;
        }
        ArrayList<ItemStack> spells = new ArrayList<ItemStack>();
        List<String> keys = ((WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getInventory().getList("Items", 10).stream().map(tag -> ((CompoundTag)tag).getString("id")).toList();
        for (String spell : keys) {
            Item effect = (Item)((Registry)ItemRegister.ITEMS.getRegistry().get()).get(ResourceLocation.parse((String)spell));
            if (effect == null || !(effect instanceof SpellEffectItem)) continue;
            SpellEffectItem sei = (SpellEffectItem)effect;
            spells.add(sei.getDefaultInstance());
        }
        RenderToolTips.renderStats(e, stack);
        RenderToolTips.render(e, spells);
    }

    private static void renderForScroll(RenderTooltipEvent.GatherComponents e, ItemStack stack) {
        ArrayList<ItemStack> spells = new ArrayList<ItemStack>();
        ScrollDataComponent.ScrollData data = (ScrollDataComponent.ScrollData)stack.get((DataComponentType)DataComponentsRegister.SCROLL_COMPONENT.get());
        for (String spell : data.getSpells()) {
            Item effect = (Item)((Registry)ItemRegister.ITEMS.getRegistry().get()).get(ResourceLocation.parse((String)spell));
            if (effect == null || !(effect instanceof SpellEffectItem)) continue;
            SpellEffectItem sei = (SpellEffectItem)effect;
            spells.add(sei.getDefaultInstance());
        }
        RenderToolTips.render(e, spells);
    }

    private static void render(RenderTooltipEvent.GatherComponents e, List<ItemStack> spells) {
        List list = e.getTooltipElements();
        int rmvIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            PlainTextContents.LiteralContents tc;
            Component comp;
            Object object;
            Optional o = ((Either)list.get(i)).left();
            if (!o.isPresent() || !((object = o.get()) instanceof Component) || !((object = (comp = (Component)object).getContents()) instanceof PlainTextContents.LiteralContents) || !"WAND_SPELLS_MARKER".equals((tc = (PlainTextContents.LiteralContents)object).text())) continue;
            rmvIdx = i;
            list.remove(i);
            break;
        }
        if (rmvIdx == -1) {
            return;
        }
        if (spells.isEmpty()) {
            return;
        }
        e.getTooltipElements().add(rmvIdx, Either.right((Object)new SpellTooltipRenderer.SpellTooltipComponent(spells.stream().limit(16L).toList(), spells.size() > 16)));
    }

    private static void renderStats(RenderTooltipEvent.GatherComponents e, ItemStack stack) {
        List list = e.getTooltipElements();
        int rmvIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            PlainTextContents.LiteralContents tc;
            Component comp;
            Object object;
            Optional o = ((Either)list.get(i)).left();
            if (!o.isPresent() || !((object = o.get()) instanceof Component) || !((object = (comp = (Component)object).getContents()) instanceof PlainTextContents.LiteralContents) || !"WAND_STATS_MARKER".equals((tc = (PlainTextContents.LiteralContents)object).text())) continue;
            rmvIdx = i;
            list.remove(i);
            break;
        }
        if (rmvIdx == -1) {
            return;
        }
        e.getTooltipElements().add(rmvIdx, Either.right((Object)new SpellStatsTooltipRenderer.SpellStatsComponent(stack)));
    }
}

