/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.event;

import com.hakimen.wandrous.client.utils.RenderUtils;
import com.hakimen.wandrous.common.item.InscribedLensItem;
import com.hakimen.wandrous.common.item.SpellEffectItem;
import com.hakimen.wandrous.common.item.component.WandDataComponent;
import com.hakimen.wandrous.common.registers.DataComponentsRegister;
import com.hakimen.wandrous.common.registers.ItemRegister;
import com.hakimen.wandrous.common.utils.ChargesUtils;
import com.hakimen.wandrous.common.utils.GlyphUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="wandrous")
public class AddItemDecorator {
    @SubscribeEvent
    public static void renderDecoration(RegisterItemDecorationsEvent event) {
        ((Registry)ItemRegister.ITEMS.getRegistry().get()).stream().filter(item -> {
            SpellEffectItem sei;
            return item instanceof SpellEffectItem && ChargesUtils.hasCharge((sei = (SpellEffectItem)((Object)item)).getDefaultInstance());
        }).toList().forEach(toRender -> event.register((ItemLike)toRender, (guiGraphics, font, stack, xOffset, yOffset) -> {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(font, "" + ChargesUtils.currentCharges(stack), xOffset * 2 + 30 - font.width("" + ChargesUtils.currentCharges(stack)), yOffset * 2 + 22, ChargesUtils.currentCharges(stack) == 0 ? 0xFF5555 : 0xFFFFFF);
            guiGraphics.pose().popPose();
            return true;
        }));
        event.register((ItemLike)ItemRegister.WAND.get(), (guiGraphics, font, stack, xOffset, yOffset) -> {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            if (((WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get())).getWandCooldown() > 0) {
                WandDataComponent.WandStat stat = (WandDataComponent.WandStat)stack.get((DataComponentType)DataComponentsRegister.WAND_COMPONENT.get());
                guiGraphics.fill(RenderType.guiOverlay(), xOffset, (int)((float)(yOffset + 16) - (float)stat.getWandCooldown() / (float)stat.getMaxCooldown() * 16.0f), xOffset + 16, yOffset + 16, stat.isFromCastDelay() ? 0x64FFFFFF : 1694484423);
            }
            guiGraphics.pose().popPose();
            return false;
        });
        ((Registry)ItemRegister.ITEMS.getRegistry().get()).stream().filter(item -> item instanceof InscribedLensItem).forEach(item -> event.register((ItemLike)item, (gfx, font, stack, xOffset, yOffset) -> {
            gfx.pose().pushPose();
            gfx.pose().translate(0.0f, 0.0f, 200.0f);
            gfx.pose().scale(0.5f, 0.5f, 0.5f);
            ResourceLocation location = GlyphUtils.getGlyphTextureFromStack(stack);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
            RenderSystem.setShader(GameRenderer::getRendertypeEntityTranslucentShader);
            VertexConsumer consumer = gfx.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)location));
            Matrix4f mat = gfx.pose().last().pose();
            RenderUtils.guiQuad(consumer, mat, gfx.pose().last(), new Vector3f((float)(xOffset * 2) + 8.5f, (float)(yOffset * 2 + 8), 0.0f), new Vector3f(14.0f, 16.0f, 0.0f), new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0xF000E0, GlyphUtils.getColorFromGlyph(stack));
            gfx.pose().popPose();
            return false;
        }));
    }
}

