/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.entity;

import com.hakimen.wandrous.common.entity.static_spell.TriggeringGlyphEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TriggeringGlyphRenderer
extends EntityRenderer<TriggeringGlyphEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/entity/magic_circle.png");

    public TriggeringGlyphRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(TriggeringGlyphEntity timerEntity) {
        return TEXTURE;
    }

    public void render(TriggeringGlyphEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        float radius = ((Float)pEntity.getEntityData().get(TriggeringGlyphEntity.RADIUS)).floatValue() * 2.0f;
        UUID uuid = (UUID)((Optional)pEntity.getEntityData().get(TriggeringGlyphEntity.OWNER)).get();
        TriggeringGlyphRenderer.blitTexture(pPoseStack, pBuffer, TEXTURE, (pPartialTick + (float)pEntity.tickCount) / 30.0f, radius, uuid.equals(Minecraft.getInstance().player.getUUID()));
        super.render((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    protected int getBlockLightLevel(TriggeringGlyphEntity pEntity, BlockPos pPos) {
        return 15;
    }

    private static void blitTexture(PoseStack pPoseStack, MultiBufferSource pBuffer, ResourceLocation extra, float rotation, float radius, boolean renderFully) {
        pPoseStack.pushPose();
        PoseStack.Pose posestack$pose = pPoseStack.last();
        pPoseStack.scale(radius, radius, radius);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        pPoseStack.mulPose(Axis.ZN.rotation(rotation));
        pPoseStack.translate(0.0f, 0.0f, 0.01f);
        Matrix4f matrix4f = posestack$pose.pose();
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)extra));
        TriggeringGlyphRenderer.vertex(vertexconsumer, matrix4f, 0xFF00E0, 0.0f, 0.0f, 0, 1, 255, 255, 255, renderFully ? 255 : 10);
        TriggeringGlyphRenderer.vertex(vertexconsumer, matrix4f, 0xFF00E0, 1.0f, 0.0f, 1, 1, 255, 255, 255, renderFully ? 255 : 10);
        TriggeringGlyphRenderer.vertex(vertexconsumer, matrix4f, 0xFF00E0, 1.0f, 1.0f, 1, 0, 255, 255, 255, renderFully ? 255 : 10);
        TriggeringGlyphRenderer.vertex(vertexconsumer, matrix4f, 0xFF00E0, 0.0f, 1.0f, 0, 0, 255, 255, 255, renderFully ? 255 : 10);
        pPoseStack.popPose();
    }

    public boolean shouldRender(TriggeringGlyphEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        Leashable leashable;
        Entity entity;
        float radius = ((Float)pLivingEntity.getEntityData().get(TriggeringGlyphEntity.RADIUS)).floatValue() * 2.0f;
        if (!pLivingEntity.shouldRender(pCamX, pCamY, pCamZ)) {
            return false;
        }
        if (pLivingEntity.noCulling) {
            return true;
        }
        AABB aabb = AABB.ofSize((Vec3)pLivingEntity.getPosition(0.0f), (double)1.0, (double)1.0, (double)1.0).inflate((double)radius, 1.0, (double)radius);
        if (pCamera.isVisible(aabb)) {
            return true;
        }
        if (pLivingEntity instanceof Leashable && (entity = (leashable = (Leashable)pLivingEntity).getLeashHolder()) != null) {
            return pCamera.isVisible(entity.getBoundingBoxForCulling());
        }
        return false;
    }

    private static void vertex(VertexConsumer pConsumer, Matrix4f pPose, int pLightmapUV, float pX, float pY, int pU, int pV, int r, int g, int b, int a) {
        pConsumer.addVertex(pPose, pX - 0.5f, pY - 0.5f, 0.0f).setColor(r, g, b, a).setUv((float)pU, (float)pV).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(pLightmapUV, pLightmapUV).setNormal(1.0f, 1.0f, 1.0f);
    }
}

