/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.entity;

import com.hakimen.wandrous.common.entity.static_spell.TimerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class TimerEntityRenderer
extends EntityRenderer<TimerEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/entity/timer/base.png");
    private static final ResourceLocation SMALL_ARM = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/entity/timer/small.png");
    private static final ResourceLocation BIG_ARM = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/entity/timer/large.png");

    public TimerEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(TimerEntity timerEntity) {
        return TEXTURE;
    }

    public void render(TimerEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        int maxTickTime = (Integer)pEntity.getEntityData().get(TimerEntity.MAX_TICK_TIME);
        TimerEntityRenderer.renderBase(pPoseStack, pBuffer, pPackedLight);
        TimerEntityRenderer.renderSmallArm(pPoseStack, pBuffer, pPackedLight);
        TimerEntityRenderer.renderBigArm(pPoseStack, pBuffer, pPackedLight, pPartialTick, pEntity.tickCount, maxTickTime);
        super.render((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    protected int getBlockLightLevel(TimerEntity pEntity, BlockPos pPos) {
        return 15;
    }

    protected int getSkyLightLevel(TimerEntity pEntity, BlockPos pPos) {
        return 15;
    }

    public static void renderBase(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        TimerEntityRenderer.blitTexture(pPoseStack, pBuffer, pPackedLight, TEXTURE, 0.01f);
    }

    public static void renderSmallArm(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        TimerEntityRenderer.blitTexture(pPoseStack, pBuffer, pPackedLight, SMALL_ARM, 0.02f);
    }

    public boolean shouldRender(TimerEntity pLivingEntity, Frustum pCamera, double pCamX, double p_114494_, double pCamY) {
        return true;
    }

    private static void blitTexture(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, ResourceLocation extra, float offset) {
        float scale = 8.0f;
        pPoseStack.pushPose();
        PoseStack.Pose posestack$pose = pPoseStack.last();
        pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        pPoseStack.scale(scale, scale, scale);
        pPoseStack.translate(0.0f, 0.0f, offset);
        Matrix4f matrix4f = posestack$pose.pose();
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)extra));
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 0.0f, -0.25f, 0, 1, 0, 255, 200);
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 1.0f, -0.25f, 1, 1, 0, 255, 200);
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 1.0f, 0.75f, 1, 0, 0, 255, 200);
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 0.0f, 0.75f, 0, 0, 0, 255, 200);
        pPoseStack.popPose();
    }

    public static void renderBigArm(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, float partialTicks, float tickCount, int maxTickTime) {
        float angle = Math.min(Math.max((tickCount + partialTicks) / (float)maxTickTime, 0.0f) * 360.0f, 360.0f);
        float scale = 8.0f;
        pPoseStack.pushPose();
        PoseStack.Pose posestack$pose = pPoseStack.last();
        pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        pPoseStack.mulPose(Axis.ZN.rotationDegrees(angle));
        pPoseStack.scale(scale, scale, scale);
        pPoseStack.translate(-0.005f, -0.01f, 0.03f);
        Matrix4f matrix4f = posestack$pose.pose();
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)BIG_ARM));
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 0.0f, -0.25f, 0, 1, 0, 255, 200);
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 1.0f, -0.25f, 1, 1, 0, 255, 200);
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 1.0f, 0.75f, 1, 0, 0, 255, 200);
        TimerEntityRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 0.0f, 0.75f, 0, 0, 0, 255, 200);
        pPoseStack.popPose();
    }

    private static void vertex(VertexConsumer pConsumer, Matrix4f pPose, int pLightmapUV, float pX, float pY, int pU, int pV, int r, int g, int b) {
        pConsumer.addVertex(pPose, pX - 0.5f, pY - 0.25f, 0.0f).setColor(r, g, b, 255).setUv((float)pU, (float)pV).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(pLightmapUV, pLightmapUV).setNormal(0.0f, 0.0f, 1.0f);
    }
}

