/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.entity;

import com.hakimen.wandrous.client.renderTypes.WandrousRenderTypes;
import com.hakimen.wandrous.client.utils.VertexProcessorBuilder;
import com.hakimen.wandrous.common.entity.static_spell.NukeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class NukeRenderer
extends EntityRenderer<NukeEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/entity/nuke.png");

    public NukeRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(NukeEntity timerEntity) {
        return TEXTURE;
    }

    public void render(NukeEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        int maxTick = (Integer)pEntity.getEntityData().get(NukeEntity.MAX_TICK_TIME);
        float tickPlusPartial = pPartialTick + (float)pEntity.tickCount;
        float scale = Math.max((float)Math.sin((double)(tickPlusPartial / (float)maxTick) * Math.PI) * 2.0f, 0.0f);
        if (pEntity.tickCount >= maxTick) {
            scale = 0.0f;
        }
        pPoseStack.pushPose();
        pPoseStack.scale(scale, scale, scale);
        pPoseStack.translate(0.0, 0.25, 0.0);
        pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, -tickPlusPartial / 64.0f, 0.0f));
        VertexConsumer vertexconsumer = pBuffer.getBuffer(WandrousRenderTypes.triangle(TEXTURE));
        VertexProcessorBuilder.drawSphere(vertexconsumer, pPoseStack, 10.0f, 32, 32, 1.0f, 1.0f, 1.0f, 1.0f, pPackedLight);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.scale(scale, scale, scale);
        pPoseStack.translate(0.0, 0.25, 0.0);
        VertexConsumer outer = pBuffer.getBuffer(RenderType.debugFilledBox());
        VertexProcessorBuilder.drawSphere(outer, pPoseStack, 10.25f, 32, 32, 1.0f, 0.25f, 0.0f, 0.2f, pPackedLight);
        VertexProcessorBuilder.drawSphere(outer, pPoseStack, 10.5f, 32, 32, 1.0f, 0.75f, 0.0f, 0.4f, pPackedLight);
        pPoseStack.popPose();
    }

    protected int getBlockLightLevel(NukeEntity pEntity, BlockPos pPos) {
        return 15;
    }

    protected int getSkyLightLevel(NukeEntity pEntity, BlockPos pPos) {
        return 15;
    }

    public boolean shouldRender(NukeEntity pLivingEntity, Frustum pCamera, double pCamX, double p_114494_, double pCamY) {
        return true;
    }
}

