/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.entity;

import com.hakimen.wandrous.client.utils.VertexProcessorBuilder;
import com.hakimen.wandrous.common.entity.static_spell.ChainPrisonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;

public class ChainPrisonRenderer
extends EntityRenderer<ChainPrisonEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/entity/chain.png");

    public ChainPrisonRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(ChainPrisonEntity pEntity) {
        return TEXTURE;
    }

    public void render(ChainPrisonEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        VertexConsumer vertexconsumer;
        int i;
        float fade = 1.0f;
        if ((double)pEntity.tickCount < (double)((Integer)pEntity.getEntityData().get(ChainPrisonEntity.MAX_TICK_TIME)).intValue() * 0.1) {
            fade = (float)Math.log(((float)pEntity.tickCount + pPartialTick) / 2.0f);
        } else if ((double)pEntity.tickCount > (double)((Integer)pEntity.getEntityData().get(ChainPrisonEntity.MAX_TICK_TIME)).intValue() * 0.95) {
            fade = (float)(-Math.log(((float)pEntity.tickCount + pPartialTick - (float)((Integer)pEntity.getEntityData().get(ChainPrisonEntity.MAX_TICK_TIME)).intValue() * 0.95f) / 2.0f));
        }
        fade = Mth.clamp((float)fade, (float)0.0f, (float)1.0f);
        for (i = 0; i < 8; ++i) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0, (double)(((Float)pEntity.getEntityData().get(ChainPrisonEntity.TARGET_BB_HEIGHT)).floatValue() / 2.0f - ((Float)pEntity.getEntityData().get(ChainPrisonEntity.TARGET_BB_HEIGHT)).floatValue() / 4.0f), 0.0);
            pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.7853982f * (float)i, 0.7853982f));
            pPoseStack.translate(0.0, 0.5, 0.0);
            vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
            VertexProcessorBuilder.drawQuadTinted(vertexconsumer, pPoseStack, pPackedLight, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, fade);
            pPoseStack.popPose();
        }
        for (i = 0; i < 8; ++i) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0, 0.0, 0.0);
            pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.7853982f * (float)i, 0.7853982f));
            pPoseStack.translate(0.0, -1.5, 0.0);
            vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
            VertexProcessorBuilder.drawQuadTinted(vertexconsumer, pPoseStack, pPackedLight, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, fade);
            pPoseStack.popPose();
        }
        super.render((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    protected int getBlockLightLevel(ChainPrisonEntity pEntity, BlockPos pPos) {
        return 15;
    }
}

